<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userByParams(array $params)
 * @method artlistByParams(array $params)
 * @method productsByParams(array $params)
 * @method dsInfoByParams(array $params)
 * @method orderByParams(array $params)
 * @method npsByParams(array $params)
 * @method moreNpsByParams(array $params)
 * @method staffsByParams(array $params)
 * @method openIdByParams(array $params)
 * @method productsInfoByParams(array $params)
 * @method addWorkloadByParams(array $params)
 * @method workloadByParams(array $params)
 * @method storesByParams(array $params)
 * @method refundsByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method checkPhoneByParams(array $params)
 * @method checkOpenIdByParams(array $params)
 * @method changePasswardByParams(array $params)
 * @method getUserOrderByParams(array $params)
 * @method sendGuardFairyPushByParams(array $params)
 * @method recordCloudTimeByParams(array $params)
 * @method getUserInfoByParams(array $params)
 */
class Cloud {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单个用户基本信息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function user () {
        return self::getClass()->user();
    }

    /**
     * 批量获取订单对应的化妆师
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function artlist () {
        return self::getClass()->artlist();
    }

    /**
     * 批量获取产品信息
     *
     * @support  array $store_ids 门店id 
     * @support  string $token token [ require true ]
     * @support  int $nodeId nodeId [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function products () {
        return self::getClass()->products();
    }

    /**
     * 获取单个/多个订单的二销信息
     *
     * @support  array $order_nums 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dsInfo () {
        return self::getClass()->dsInfo();
    }

    /**
     * 获取单个/多个订单详情/产品列表
     *
     * @support  array $order_nums 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function order () {
        return self::getClass()->order();
    }

    /**
     * 获取单个订单NPs详情
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function nps () {
        return self::getClass()->nps();
    }

    /**
     * 获取多个订单NPs详情
     *
     * @support  array $order_nums 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function moreNps () {
        return self::getClass()->moreNps();
    }

    /**
     * 批量获取伙伴的信息
     *
     * @support  array $store_ids 门店 
     * @support  array $staff_ids 伙伴工号 
     * @support  array $position_ids 工作岗位 
     * @support  string $start_date 查询开始时间 
     * @support  string $end_date 查询结束时间 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staffs () {
        return self::getClass()->staffs();
    }

    /**
     * 通过用户的id获取用户的openid
     *
     * @support  array $user_ids 伙伴工号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function openId () {
        return self::getClass()->openId();
    }

    /**
     * 通过product_ids批量获取产品信息
     *
     * @support  array $product_ids 产品ids 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productsInfo () {
        return self::getClass()->productsInfo();
    }

    /**
     * 录入工作量信息
     *
     * @support  int $order_num 订单号 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  string $staff_type 员工类型 [ require true ]
     * @support  int $work_per 工作量 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addWorkload () {
        return self::getClass()->addWorkload();
    }

    /**
     * 批量获取工作量信息
     *
     * @support  string $staff_type 伙伴类型 
     * @support  array $order_nums 订单号 
     * @support  int $staff_id 伙伴工号 [Original type uint] 
     * @support  string $start_time 录单开始时间 
     * @support  string $end_time 录单开始时间 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function workload () {
        return self::getClass()->workload();
    }

    /**
     * 根据门店id获取门店信息
     *
     * @support  array $store_ids 门店IDS [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stores () {
        return self::getClass()->stores();
    }

    /**
     * 批量获取退款信息
     *
     * @support  array $order_nums 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function refunds () {
        return self::getClass()->refunds();
    }

    /**
     * 订单详情
     *
     * @support  string $order_num 订单号 
     * @support  array $status 订单状态 
     * @support  string $user_name 下单用户 
     * @support  int $store_id 门店id 
     * @support  string $phone 顾客手机号 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 通过手机号验证登录
     *
     * @support  string $phone 顾客手机号 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkPhone () {
        return self::getClass()->checkPhone();
    }

    /**
     * 通过openid验证登录
     *
     * @support  string $open_id open_id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOpenId () {
        return self::getClass()->checkOpenId();
    }

    /**
     * 重置密码
     *
     * @support  string $phone 顾客手机号 [ require true ]
     * @support  string $password 新密码 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePassward () {
        return self::getClass()->changePassward();
    }

    /**
     * 获取用户订单信息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  string $status 订单状态 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserOrder () {
        return self::getClass()->getUserOrder();
    }

    /**
     * 推送仙女照活动
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  array $productIds 产品数组[1,2,3] [ require true ]
     * @param  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGuardFairyPush (string $orderNum, array $productIds, string $token) {
        return self::getClass()->sendGuardFairyPush([
            "orderNum" => $orderNum,
            "productIds" => $productIds,
            "token" => $token,
        ]);
    }

    /**
     * 记录云端订单开始与结束时间
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $cloud_create_time 云端订单开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordCloudTime () {
        return self::getClass()->recordCloudTime();
    }

    /**
     * 通过手机号获取用户信息
     *
     * @support  string $phone 顾客手机号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Cloud');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Cloud');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}