<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editShowInfoByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建单品折扣
     *
     * @support  string $name 折扣名称 
     * @support  array $node_ids 节点名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [Original type uint] 
     * @support  array $store_ids 门店id数组 
     * @support  float $incentives_num 优惠力度 [Original type double] 
     * @support  string $discount_type 折扣类型 
     * @support  string $start_time 折扣开始时间 
     * @support  string $end_time 折扣结束时间 
     * @support  array $show_info 前端显示信息 
     * @support  bool $include_addition 打折是否包含子节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改折扣展示信息
     *
     * @support  int $discount_id 折扣id [Original type uint] 
     * @support  array $show_info 前端展示信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editShowInfo () {
        return self::getClass()->editShowInfo();
    }

    /**
     * 单品折扣列表
     *
     * @support  int $limit 限制值 [Original type uint] 
     * @support  int $from_id 起始ID(第一页不用传,之后传每一页的最后一条数据id.且在第一页会返回总数据条数(count)) [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 单品折扣删除
     *
     * @param  int $id 关闭 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}