<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method storesByParams(array $params)
 * @method typesByParams(array $params)
 */
class Deposit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量录入
     *
     * @support  array $data 数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 保证金录入
     *
     * @support  string $number 编号 [ require true ]
     * @support  string $type 保证金类型 [ require true ]
     * @support  string $store 乙方门店 [ require true ]
     * @support  string $region 乙方区域 [ require true ]
     * @support  string $company 乙方单位 [ require true ]
     * @support  string $pay_date 打款时间 [ require true ]
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  string $img 图片地址 
     * @support  string $remark 备注 
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） [ require true ]
     * @support  bool $other_store 是否是其他门店 [ require true ]
     * @support  int $create_user 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 保证金查询
     *
     * @support  string $state 状态（wait_use-待领用 using-领用中 used-已领用） 
     * @support  string $store 门店 
     * @support  string $pay_date 打款时间 
     * @support  string $use_date 领用时间 
     * @support  string $refund_date 收到退款时间 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @support  string $number 编号 
     * @support  float $money 金额 [Original type double] 
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） 
     * @support  bool $all 是否返回所有结果 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 编辑
     *
     * @support  string $_id id [ require true ]
     * @support  string $number 编号 
     * @support  string $type 保证金类型 
     * @support  string $store 乙方门店 
     * @support  string $region 乙方区域 
     * @support  string $company 乙方单位 
     * @support  string $pay_date 打款时间 
     * @support  float $money 金额 [Original type unsignedDouble] 
     * @support  string $img 图片地址 
     * @support  string $remark 备注 
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） 
     * @support  bool $other_store 是否是其他门店 
     * @support  int $create_user 操作人 
     * @support  string $state 状态位 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取详情
     *
     * @support  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取其他门店
     *
     * @support  string $query 搜索条件 
     * @throws  \Exception
     * @return  array
     */
    public static function stores () {
        return self::getClass()->stores();
    }

    /**
     * 类型
     *
     * @support  string $query 条件 
     * @throws  \Exception
     * @return  array
     */
    public static function types () {
        return self::getClass()->types();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Deposit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Deposit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}