<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method itemsByParams(array $params)
 * @method payByParams(array $params)
 */
class OfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建线下订单
     *
     * @support  int $amount  [ require true ]
     * @support  float $money 订单金额 [ require true ]
     * @support  int $income_item_id 线下收入项目ID [ require true ]
     * @support  array $child_item_nums 线下收入子项 [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  string $reserve_time 预约时间 [ require false ]
     * @support  string $service_time 服务时间 [ require false ]
     * @support  array $coupon_ids 券码ids [ require false ]
     * @support  int $user_id 用户ID [ require false ]
     * @support  array $print_nums 打印数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 线下订单详情
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 线下订单详情【使用订单号】
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByNo () {
        return self::getClass()->detailByNo([
        ]);
    }

    /**
     * 线下订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 [ require false ]
     * @support  int $item_id 收入项id [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $status_list 状态列表 [ require false ]
     * @support  string $order_no 订单编号 [ require false ]
     * @support  string $paid_at_start 支付时间起始 [ require false ]
     * @support  string $paid_at_end 支付时间结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 删除线下订单
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 线下产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function items () {
        return self::getClass()->items();
    }

    /**
     * 线下订单支付
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pay () {
        return self::getClass()->pay([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}