<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command\CreateRefundCommand $params)
 * @method createReviewByParams(array $params)
 * @method reviewCallbackByParams(array $params)
 */
class GroupOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建团购退款
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command\CreateRefundCommand $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command\CreateRefundCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * 发起团购退款审批
     *
     * @param  int $refundId 团购订单退款id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createReview (int $refundId) {
        return self::getClass()->createReview([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 团购订单退款审批回调
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function reviewCallback () {
        return self::getClass()->reviewCallback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\GroupOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\GroupOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}