<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|OrderCompensation\Create\OrderCompensationDto $params)
 * @method detailByParams(array|OrderCompensation\Detail\DetailDto $params)
 * @method operationLogDetailByParams(array|OrderCompensation\OperationLogDetail\DetailDto $params)
 * @method terminateProcessByParams(array|OrderCompensation\TerminateProcess\TerminateProcessDto $params)
 * @method sendSatisfactionSurveyByParams(array $params)
 * @method saveSatisfactionSurveyByParams(array|OrderCompensation\SaveSatisfactionSurvey\SatisfactionSurveyDto $params)
 * @method orderCompensationReviewCallbackByParams(array $params)
 */
class OrderCompensation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后补偿订单
     *
     * @var  OrderCompensation\Create\OrderCompensationDto $dto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (OrderCompensation\Create\OrderCompensationDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 获取发起售后订单详情
     *
     * @var  OrderCompensation\Detail\DetailDto $dto $dto
     * @throws  \Exception
     * @return  OrderCompensation\Detail\DetailResDto
     */
    public static function detail (OrderCompensation\Detail\DetailDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail($dto),
            "\Mainto\Bridge\Invokes\HimoProductStore\Admin\OrderCompensation\Detail\DetailResDto"
        );
    }


    /**
     * 获售后订单操作详情
     *
     * @var  OrderCompensation\OperationLogDetail\DetailDto $dto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationLogDetail (OrderCompensation\OperationLogDetail\DetailDto $dto) {
        return self::getClass()->operationLogDetail($dto);
    }


    /**
     * 撤回售后赔偿订单申请
     *
     * @var  OrderCompensation\TerminateProcess\TerminateProcessDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateProcess (OrderCompensation\TerminateProcess\TerminateProcessDto $dto) {
        return self::getClass()->terminateProcess($dto);
    }


    /**
     * 发送售后评价消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSatisfactionSurvey () {
        return self::getClass()->sendSatisfactionSurvey();
    }

    /**
     * 保存售后评价消息
     *
     * @var  OrderCompensation\SaveSatisfactionSurvey\SatisfactionSurveyDto $dto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSatisfactionSurvey (OrderCompensation\SaveSatisfactionSurvey\SatisfactionSurveyDto $dto) {
        return self::getClass()->saveSatisfactionSurvey($dto);
    }


    /**
     * 钉钉审批结果回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderCompensationReviewCallback () {
        return self::getClass()->orderCompensationReviewCallback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OrderCompensation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OrderCompensation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}