<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrUpdateByParams(array $params)
 * @method getByParams(array $params)
 */
class PreferenceInfoMore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建或添加订单偏好信息更多信息
     *
     * @support  int $order_no 订单id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrUpdate () {
        return self::getClass()->createOrUpdate();
    }

    /**
     * 获取订单偏好更多信息
     *
     * @support  int $order_no 订单ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function get () {
        return self::getClass()->get();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\PreferenceInfoMore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\PreferenceInfoMore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}