<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-18 14:41:45
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Inventory
 */
class Inventory {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Erp\\Inventory";

    /**
     * 根据类型获取物料数量
     * @return  array
    */
    public static function getStockCount (string $locType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockCount(["locType" => $locType]);
    }
    /**
     * 提交盘点结果
     * @return  bool
    */
    public static function submit (int $staffId, int $locType, array $materialInfo, string $status = 'consistent', string $applyIn = 'store', int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["staffId" => $staffId, "locType" => $locType, "materialInfo" => $materialInfo, "status" => $status, "applyIn" => $applyIn, "id" => $id]);
    }
    /**
     * 盘点列表
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10, string $startTime, string $endTime, string $locType, string $staffId, string $applyIn, string $checkStatus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "startTime" => $startTime, "endTime" => $endTime, "locType" => $locType, "staffId" => $staffId, "applyIn" => $applyIn, "checkStatus" => $checkStatus]);
    }
    /**
     * 盘点详情
     * @return  mixed
    */
    public static function detail (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId]);
    }
    /**
     * 盘点审核通过后,进行库存的同步操作
     * @return  mixed
    */
    public static function addInventoryStockRecord (array $inventoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addInventoryStockRecord(["inventoryIds" => $inventoryIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}