<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-18 15:27:00
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\Staff";

    /**
     * 获取员工列表
     * @return  mixed
    */
    public static function list (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["store_id" => $store_id]);
    }
    /**
     * 通过员工id获取信息
     * @return  array
    */
    public static function getStaffInfoByIds (array $staffIds, string $includeLeaveDate = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoByIds(["staffIds" => $staffIds, "includeLeaveDate" => $includeLeaveDate]);
    }
    /**
     * 根据分类获取门店成员列表
     * @return  mixed
    */
    public static function storeStaff (int $store_id, string $staff_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeStaff(["store_id" => $store_id, "staff_type" => $staff_type]);
    }
    /**
     * 获取门店管理伙伴名单
     * @return  array
    */
    public static function getStaffManager (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffManager(["storeId" => $storeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}