<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-18 15:27:00
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductTree
 */
class ProductTree {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\ProductTree";

    /**
     * 全部产品列表
     * @return  mixed
    */
    public static function getAllProduct (int $category_id, string $name, string $full_name, bool $show_deleted, string $module, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct(["category_id" => $category_id, "name" => $name, "full_name" => $full_name, "show_deleted" => $show_deleted, "module" => $module, "status" => $status]);
    }
    /**
     * 获取门店产品树
     * @return  mixed
    */
    public static function getStoreProduct (string $status = 'on', int $show_level = 2, string $order_by_sort = 'desc', bool $c_hidden, bool $c_hidden_retail, bool $is_mainto_photography, bool $is_style, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProduct(["status" => $status, "show_level" => $show_level, "order_by_sort" => $order_by_sort, "c_hidden" => $c_hidden, "c_hidden_retail" => $c_hidden_retail, "is_mainto_photography" => $is_mainto_photography, "is_style" => $is_style, "store_id" => $store_id]);
    }
    /**
     * 获取门店产品树
     * @return  array
    */
    public static function getStoreSimpleProduct (int $storeId, string $status = 'all', string $orderBySort = 'desc', int $showLevel = 1) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreSimpleProduct(["storeId" => $storeId, "status" => $status, "orderBySort" => $orderBySort, "showLevel" => $showLevel]),
            "\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\DTO\ProductSimpleTreeDTO[]"
        );
    }
    /**
     * 获取门店隐藏产品列表
     * @return  mixed
    */
    public static function getStoreHideProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreHideProduct();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}