<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-25 14:29:31
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SamplePhoto
 */
class SamplePhoto {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\SamplePhoto";

    /**
     * 创建样片
     * @return  mixed
    */
    public static function create (string $brand, array $label, string $type, string $name, string $expired_at, array $images, string $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["brand" => $brand, "label" => $label, "type" => $type, "name" => $name, "expired_at" => $expired_at, "images" => $images, "evidence" => $evidence]);
    }
    /**
     * 获取样片列表
     * @return  mixed
    */
    public static function list (string $brand, string $type, array $label, int $product_id, array $product_ids, int $expired_days, int $uper, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["brand" => $brand, "type" => $type, "label" => $label, "product_id" => $product_id, "product_ids" => $product_ids, "expired_days" => $expired_days, "uper" => $uper, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取样片详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 审核通过
     * @return  mixed
    */
    public static function pass (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id]);
    }
    /**
     * 移除客片
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 下架样片
     * @return  mixed
    */
    public static function offShelf (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offShelf(["id" => $id]);
    }
    /**
     * 上架样片
     * @return  mixed
    */
    public static function onShelf (int $id, string $expired_at, string $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onShelf(["id" => $id, "expired_at" => $expired_at, "evidence" => $evidence]);
    }
    /**
     * 下载样片
     * @return  mixed
    */
    public static function download (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->download(["id" => $id]);
    }
    /**
     * 订单客片
     * @return  mixed
    */
    public static function orderPhoto (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderPhoto(["order_num" => $order_num]);
    }
    /**
     * 获取样片类型
     * @return  array
    */
    public static function samplePhotoType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->samplePhotoType();
    }
    /**
     * 获取过期天数
     * @return  array
    */
    public static function samplePhotoExpirationDateType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->samplePhotoExpirationDateType();
    }
    /**
     * 获取样片池上传人列表
     * @return  mixed
    */
    public static function allUper (string $name, string $nickname, string $nameOrNickname, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allUper(["name" => $name, "nickname" => $nickname, "nameOrNickname" => $nameOrNickname, "phone" => $phone]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}