<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-21 16:59:43
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GroupOrder
 */
class GroupOrder {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\GroupOrder";

    /**
     * 团购订单列表
     * @return  mixed
    */
    public static function list (string $business_name, string $type, string $user_name, string $user_phone, array $order_ids, string $order_no, string $status, int $is_private_pay, int $is_installment, string $installment_status, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["business_name" => $business_name, "type" => $type, "user_name" => $user_name, "user_phone" => $user_phone, "order_ids" => $order_ids, "order_no" => $order_no, "status" => $status, "is_private_pay" => $is_private_pay, "is_installment" => $is_installment, "installment_status" => $installment_status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (string $business_name, string $user_name, string $user_phone, string $email, array $detail, string $type, string $note, bool $is_installment, bool $is_private_pay, float $money, float $pay_money, float $discount, float $down_payment_money, float $balance_payment_money, string $private_user_name, string $private_user_phone, string $group_internal_contact, float $outside_shot_money, array $package_discount_ids, int $is_attach_use) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["business_name" => $business_name, "user_name" => $user_name, "user_phone" => $user_phone, "email" => $email, "detail" => $detail, "type" => $type, "note" => $note, "is_installment" => $is_installment, "is_private_pay" => $is_private_pay, "money" => $money, "pay_money" => $pay_money, "discount" => $discount, "down_payment_money" => $down_payment_money, "balance_payment_money" => $balance_payment_money, "private_user_name" => $private_user_name, "private_user_phone" => $private_user_phone, "group_internal_contact" => $group_internal_contact, "outside_shot_money" => $outside_shot_money, "package_discount_ids" => $package_discount_ids, "is_attach_use" => $is_attach_use]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (int $id, string $group_order_type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "group_order_type" => $group_order_type]);
    }
    /**
     * 订单支付（全款与首款）
     * @return  mixed
    */
    public static function paid (int $id, string $pay_type, string $paid_at, float $money, string $payment_no, array $certificates, string $type, string $group_order_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "pay_type" => $pay_type, "paid_at" => $paid_at, "money" => $money, "payment_no" => $payment_no, "certificates" => $certificates, "type" => $type, "group_order_type" => $group_order_type]);
    }
    /**
     * 取消订单
     * @return  mixed
    */
    public static function cancel (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id]);
    }
    /**
     * 支付尾款
     * @return  mixed
    */
    public static function balanceEntry (int $order_id, string $pay_type, string $paid_at, float $money, string $payment_no, bool $is_change, array $detail, array $certificates, string $group_order_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceEntry(["order_id" => $order_id, "pay_type" => $pay_type, "paid_at" => $paid_at, "money" => $money, "payment_no" => $payment_no, "is_change" => $is_change, "detail" => $detail, "certificates" => $certificates, "group_order_type" => $group_order_type]);
    }
    /**
     * 获取关联拍摄订单
     * @return  mixed
    */
    public static function getPhotoOrders (int $group_order_id, string $order_no, string $user_name, string $user_phone, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoOrders(["group_order_id" => $group_order_id, "order_no" => $order_no, "user_name" => $user_name, "user_phone" => $user_phone, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取券码关联订单
     * @return  mixed
    */
    public static function getProductCardOrders (int $group_order_id, string $user_name, string $user_phone, string $himo_order_no, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardOrders(["group_order_id" => $group_order_id, "user_name" => $user_name, "user_phone" => $user_phone, "himo_order_no" => $himo_order_no, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 删除预约产品
     * @return  mixed
    */
    public static function deleteOrderItem (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrderItem(["id" => $id]);
    }
    /**
     * 发送邮件
     * @return  mixed
    */
    public static function sendEmailTest (string $email, string $templateName, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendEmailTest(["email" => $email, "templateName" => $templateName, "data" => $data]);
    }
    /**
     * reviewCallback
     * @return  mixed
    */
    public static function reviewCallback () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewCallback();
    }
    /**
     * 审核团购单
     * @return  mixed
    */
    public static function reviewOrder (array $res, int $adminId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewOrder(["res" => $res, "adminId" => $adminId]);
    }
    /**
     * 获取门店
     * @return  mixed
    */
    public static function getStoresByType (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoresByType(["type" => $type]);
    }
    /**
     * 获取价格区和对应门店
     * @return  mixed
    */
    public static function getPriceAreaStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPriceAreaStore();
    }
    /**
     * 根据门店ids获取对应产品信息
     * @return  mixed
    */
    public static function getAvailableProducts (string $storeIds, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableProducts(["storeIds" => $storeIds, "type" => $type]);
    }
    /**
     * 提取券码
     * @return  mixed
    */
    public static function drawCode (array $num, int $order_id, array $item_ids, string $pay_type, string $user_phone, string $user_sex, string $user_name, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->drawCode(["num" => $num, "order_id" => $order_id, "item_ids" => $item_ids, "pay_type" => $pay_type, "user_phone" => $user_phone, "user_sex" => $user_sex, "user_name" => $user_name, "code" => $code]);
    }
    /**
     * 导出券码列表
     * @return  mixed
    */
    public static function exportProductCardCodes (int $order_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportProductCardCodes(["order_id" => $order_id, "code" => $code]);
    }
    /**
     * 获取店长手机号
     * @return  mixed
    */
    public static function getPhone () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhone();
    }
    /**
     * 团购单审核
     * @return  mixed
    */
    public static function handleGroupOrder (int $payId, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleGroupOrder(["payId" => $payId, "id" => $id]);
    }
    /**
     * 根据支付方式获取订单列表
     * @return  mixed
    */
    public static function getListByPay (string $pay_type, string $paid_at_start, string $paid_at_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPay(["pay_type" => $pay_type, "paid_at_start" => $paid_at_start, "paid_at_end" => $paid_at_end, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取团购订单的剩余金额
     * @return  float
    */
    public static function getExactGroupOrderBalance (int $groupOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExactGroupOrderBalance(["groupOrderId" => $groupOrderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}