<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-28 11:36:30
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Reservation
 */
class Reservation {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\Reservation";

    /**
     * 排单表
     * @return  mixed
    */
    public static function list (string $date_start, string $date_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["date_start" => $date_start, "date_end" => $date_end]);
    }
    /**
     * 获取指定日期的所有大订单id(拍摄订单非看片大订单)
     * @return  mixed
    */
    public static function bigOrderAll (string $date_start, string $date_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrderAll(["date_start" => $date_start, "date_end" => $date_end]);
    }
    /**
     * 关闭/开放时间节点
     * @return  mixed
    */
    public static function openClose (string $order_time, string $state, int $index) {
        return RpcClass::getClass(self::$serviceName, self::$className)->openClose(["order_time" => $order_time, "state" => $state, "index" => $index]);
    }
    /**
     * 批量关闭时间节点
     * @return  mixed
    */
    public static function batchClose (int $each_time_unset, string $date_begin, string $date_end, string $time_begin, string $time_end, bool $all_success = false, bool $is_repeat = false, string $reason, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["each_time_unset" => $each_time_unset, "date_begin" => $date_begin, "date_end" => $date_end, "time_begin" => $time_begin, "time_end" => $time_end, "all_success" => $all_success, "is_repeat" => $is_repeat, "reason" => $reason, "type" => $type]);
    }
    /**
     * 批量打开时间节点
     * @return  bool
    */
    public static function batchOpen (\Mainto\Bridge\Structs\HimoProductStore\Schedule\Dto\BatchDto $batchDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchOpen($batchDto);
    }
    /**
     * 关闭/开放时间节点记录
     * @return  mixed
    */
    public static function closeList (int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeList(["page" => $page, "page_size" => $page_size]);
    }
    /**
     * 删除关闭记录
     * @return  mixed
    */
    public static function closeDelete (string $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeDelete(["id" => $id]);
    }
    /**
     * 管理端获取可改约的时间
     * @return  mixed
    */
    public static function getReserveList (int $store_id, string $date_start, string $date_end, array $product_group) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReserveList(["store_id" => $store_id, "date_start" => $date_start, "date_end" => $date_end, "product_group" => $product_group]);
    }
    /**
     * 排单表占点
     * @return  mixed
    */
    public static function reserveOccupy (string $date_start, string $date_end, array $product_group, int $store_id, string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reserveOccupy(["date_start" => $date_start, "date_end" => $date_end, "product_group" => $product_group, "store_id" => $store_id, "orderNo" => $orderNo]);
    }
    /**
     * 战疫专属全家福券数量
     * @return  mixed
    */
    public static function antiVirusCount (string $date_start, string $date_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->antiVirusCount(["date_start" => $date_start, "date_end" => $date_end]);
    }
    /**
     * 看片排单表
     * @return  mixed
    */
    public static function lookingReservation (string $date_start, string $date_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookingReservation(["date_start" => $date_start, "date_end" => $date_end]);
    }
    /**
     * 看片关闭/开放时间节点
     * @return  mixed
    */
    public static function lookOpenClose (string $order_time, string $state, int $index) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookOpenClose(["order_time" => $order_time, "state" => $state, "index" => $index]);
    }
    /**
     * 大订单列表
     * @return  mixed
    */
    public static function bigOrderList (string $date_start, string $date_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrderList(["date_start" => $date_start, "date_end" => $date_end]);
    }
    /**
     * 支持预约看片门店列表
     * @return  mixed
    */
    public static function reviewStoreList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewStoreList();
    }
    /**
     * 初始推送
     * @return  mixed
    */
    public static function cronOnceLookingPhotoNotice () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronOnceLookingPhotoNotice();
    }
    /**
     * 获取海马体占点
     * @return  \Mainto\Bridge\Structs\HimoProductStore\DTO\HimoOccupyResultDTO
    */
    public static function getHimoOccupyResult (int $storeId, int $orderId, string $reserveTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getHimoOccupyResult(["storeId" => $storeId, "orderId" => $orderId, "reserveTime" => $reserveTime]),
            "\Mainto\Bridge\Structs\HimoProductStore\DTO\HimoOccupyResultDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}