<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-25 14:54:53
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetailCategory
 */
class RetailCategory {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Retail\\RetailCategory";

    /**
     * 创建零售产品品类
     * @return  mixed
    */
    public static function create (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name]);
    }
    /**
     * 编辑零售产品品类
     * @return  mixed
    */
    public static function update (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name]);
    }
    /**
     * 批量编辑零售产品品类
     * @return  mixed
    */
    public static function batchUpdate (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate(["data" => $data]);
    }
    /**
     * 品类详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 删除品类
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }
    /**
     * 品类分页列表
     * @return  mixed
    */
    public static function list (int $page, int $page_size, bool $show_deleted) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "page_size" => $page_size, "show_deleted" => $show_deleted]);
    }
    /**
     * 品类列表
     * @return  mixed
    */
    public static function all (bool $show_deleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["show_deleted" => $show_deleted]);
    }
    /**
     * 添加品类时获取类目N级树状列表/获取树状列表
     * @return  mixed
    */
    public static function getCategoryTree (bool $withProducts = true, int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree(["withProducts" => $withProducts, "parentId" => $parentId, "depth" => $depth, "showDeleted" => $showDeleted]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}