<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-17 19:40:58
 */
namespace Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command;

class CreateRefundCommand {
    /**
     * @var  int
     * 团购订单id
     * validation: 
     */
    public int $groupOrderId;
    /**
     * @var  string
     * 渠道
     * validation: in:store,business
     */
    public string $channel;
    /**
     * @var  float
     * 退款金额
     * validation: 
     */
    public float $refundMoney;
    /**
     * @var  string
     * 退款账户
     * validation: 
     */
    public string $receiptAccount;
    /**
     * @var  string
     * 收款人
     * validation: 
     */
    public string $receiptPeople;
    /**
     * @var  string
     * 开户银行
     * validation: 
     */
    public string $openingBank;
    /**
     * @var  null|string
     * 退款原因
     * validation: 
     */
    public ?string $reason;
    /**
     * @var  \Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command\RefundGroupOrderItemCommand[]
     * 退款的团购商品信息
     * validation: 
     */
    public array $refundItems;

    public function __construct (int $groupOrderId = 0, string $channel = '', float $refundMoney = 0.0, int $inputStaffId = 0, string $receiptAccount = '', string $receiptPeople = '', string $openingBank = '', ?string $reason = '', array $refundItems = []) {
        if (!is_null($groupOrderId)) {
            $this->groupOrderId = $groupOrderId;
        }
        if (!is_null($channel)) {
            $this->channel = $channel;
        }
        if (!is_null($refundMoney)) {
            $this->refundMoney = $refundMoney;
        }
        if (!is_null($inputStaffId)) {
            $this->inputStaffId = $inputStaffId;
        }
        if (!is_null($receiptAccount)) {
            $this->receiptAccount = $receiptAccount;
        }
        if (!is_null($receiptPeople)) {
            $this->receiptPeople = $receiptPeople;
        }
        if (!is_null($openingBank)) {
            $this->openingBank = $openingBank;
        }
        if (!is_null($reason)) {
            $this->reason = $reason;
        }
        if (!is_null($refundItems)) {
            $this->refundItems = $refundItems;
        }
    }

    public static function create(int $groupOrderId = 0, string $channel = '', float $refundMoney = 0.0, int $inputStaffId = 0, string $receiptAccount = '', string $receiptPeople = '', string $openingBank = '', ?string $reason = '', array $refundItems = []): self {
        return new self($groupOrderId, $channel, $refundMoney, $inputStaffId, $receiptAccount, $receiptPeople, $openingBank, $reason, $refundItems);
    }

    public function setGroupOrderId(int $groupOrderId): self {
        $this->groupOrderId = $groupOrderId;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setRefundMoney(float $refundMoney): self {
        $this->refundMoney = $refundMoney;

        return $this;
    }

    public function setReceiptAccount(string $receiptAccount): self {
        $this->receiptAccount = $receiptAccount;

        return $this;
    }

    public function setReceiptPeople(string $receiptPeople): self {
        $this->receiptPeople = $receiptPeople;

        return $this;
    }

    public function setOpeningBank(string $openingBank): self {
        $this->openingBank = $openingBank;

        return $this;
    }

    public function setReason(?string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setRefundItems(array $refundItems): self {
        $this->refundItems = $refundItems;

        return $this;
    }
}