<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-10 12:13:03
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Exploit
 */
class Exploit {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\Exploit";

    /**
     * 录入每日业绩核对
     * @return  mixed
    */
    public static function create (string $report_date, float $report_performance, float $report_market_performance, int $report_count, int $system_shoot_count, float $alipay, float $alipay_system, float $wechat, float $wechat_system, float $pos, float $pos_system, float $cash, float $cash_system, float $market_card, float $market_card_system, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["report_date" => $report_date, "report_performance" => $report_performance, "report_market_performance" => $report_market_performance, "report_count" => $report_count, "system_shoot_count" => $system_shoot_count, "alipay" => $alipay, "alipay_system" => $alipay_system, "wechat" => $wechat, "wechat_system" => $wechat_system, "pos" => $pos, "pos_system" => $pos_system, "cash" => $cash, "cash_system" => $cash_system, "market_card" => $market_card, "market_card_system" => $market_card_system, "reason" => $reason]);
    }
    /**
     * 更新业绩
     * @return  mixed
    */
    public static function update (string $id, string $report_date, float $report_performance, float $report_market_performance, int $report_count, int $system_shoot_count, float $alipay, float $alipay_system, float $wechat, float $wechat_system, float $pos, float $pos_system, float $cash, float $cash_system, float $market_card, float $market_card_system, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "report_date" => $report_date, "report_performance" => $report_performance, "report_market_performance" => $report_market_performance, "report_count" => $report_count, "system_shoot_count" => $system_shoot_count, "alipay" => $alipay, "alipay_system" => $alipay_system, "wechat" => $wechat, "wechat_system" => $wechat_system, "pos" => $pos, "pos_system" => $pos_system, "cash" => $cash, "cash_system" => $cash_system, "market_card" => $market_card, "market_card_system" => $market_card_system, "reason" => $reason]);
    }
    /**
     * 查询业绩
     * @return  mixed
    */
    public static function search (string $report_date_start, string $report_date_end, int $store_id, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->search(["report_date_start" => $report_date_start, "report_date_end" => $report_date_end, "store_id" => $store_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 昨日业绩是否已核对
     * @return  mixed
    */
    public static function isCheck () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCheck();
    }
    /**
     * 业绩详情
     * @return  mixed
    */
    public static function detail (string $report_date) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["report_date" => $report_date]);
    }
    /**
     * 获取绩效查询限制的时间
     * @return  array
    */
    public static function performanceFindLimitDate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->performanceFindLimitDate();
    }
    /**
     * 录入商场业绩
     * @return  bool
    */
    public static function performanceSave (\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\CMD\Exploit\MarketPerformanceCmd $marketPerformanceCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->performanceSave($marketPerformanceCmd);
    }
    /**
     * 商场业绩日汇总
     * @return  \Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\DTO\MarketPerformanceDailyDTO
    */
    public static function performanceDaily (string $date, int $store_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->performanceDaily(["date" => $date, "store_id" => $store_id]),
            "\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\DTO\MarketPerformanceDailyDTO"
        );
    }
    /**
     * 商场业绩明细数据
     * @return  array
    */
    public static function performanceDetail (string $date, string $type, int $store_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->performanceDetail(["date" => $date, "type" => $type, "store_id" => $store_id]),
            "\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\DTO\MarketPerformanceItemDTO[]"
        );
    }
    /**
     * 导出商场业绩明细数据
     * @return  string
    */
    public static function exportPerformanceDetail (string $start_date, string $end_date, string $update_at, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPerformanceDetail(["start_date" => $start_date, "end_date" => $end_date, "update_at" => $update_at, "store_id" => $store_id]);
    }
    /**
     * 导出列表
     * @return  array
    */
    public static function exportList (int $staff_id, int $page_size = 500, int $page = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportList(["staff_id" => $staff_id, "page_size" => $page_size, "page" => $page]);
    }
    /**
     * 每天7点执行-同步昨天的业绩数据
     * @return  bool
    */
    public static function cronDailySyncPerformance (string $date) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronDailySyncPerformance(["date" => $date]);
    }
    /**
     * 每10分钟执行-同步昨天的业绩数据
     * @return  mixed
    */
    public static function cronRealtimeSyncPerformance () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronRealtimeSyncPerformance();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}