<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|List\PhotographicPoseListDto $params)
 * @method selectPoseByParams(array|SelectPose\PhotographicPoseDto $params)
 */
class PhotographicPose {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单摄影动作列表
     *
     * @var  List\PhotographicPoseListDto $photographicPoseListDto $photographicPoseListDto
     * @throws  \Exception
     * @return  array
     */
    public static function list (List\PhotographicPoseListDto $photographicPoseListDto) {
        return self::getClass()->list($photographicPoseListDto);
    }


    /**
     * 选择摄影动作
     *
     * @var  SelectPose\PhotographicPoseDto $photographicPoseDto $photographicPoseDto
     * @throws  \Exception
     * @return  bool
     */
    public static function selectPose (SelectPose\PhotographicPoseDto $photographicPoseDto) {
        return self::getClass()->selectPose($photographicPoseDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\PhotographicPose');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\PhotographicPose');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}