<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncFixedAssetByParams(array $params)
 * @method stepRepairedTimeByParams(array $params)
 * @method getFixedAssetListByParams(array $params)
 */
class FixedAsset {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步固定资产信息
     *
     * @param  string $assetNumber 资产编号 [ require true ]
     * @support  int $departmentId 部门id require false
     * @support  int $storeId 门店id require false
     * @support  string $name 名称 require false
     * @support  int $locType 类型 require false
     * @support  int $onhand 数量 require false
     * @support  int $available 可用数量 require false
     * @support  string $serialNumber 资产序列号 require false
     * @support  string $lastDate 最后折旧时间 require false
     * @support  string $status 状态 require false
     * @support  int $repairedTimes 维修次数 require false
     * @support  int $isInactive 是否无效 require false
     * @support  string $explain 备注 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function syncFixedAsset (string $assetNumber = '') {
        return self::getClass()->syncFixedAsset([
            "assetNumber" => $assetNumber,
        ]);
    }

    /**
     * 固定资产增加维修次数
     *
     * @param  string $assetNumber 资产编号 [ require true ]
     * @param  int $step 增加次数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stepRepairedTime (string $assetNumber = '', int $step = 1) {
        return self::getClass()->stepRepairedTime([
            "assetNumber" => $assetNumber,
            "step" => $step,
        ]);
    }

    /**
     * 门店固定资产列表
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFixedAssetList (int $storeId) {
        return self::getClass()->getFixedAssetList([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\FixedAsset');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\FixedAsset');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}