<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 16:35:03
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Retail\\Product";

    /**
     * 获取品类树
     * @return  array
    */
    public static function getCategoryTree (int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree(["parentId" => $parentId, "depth" => $depth, "showDeleted" => $showDeleted]);
    }
    /**
     * 根据skuids获取促销活动信息
     * @return  mixed
    */
    public static function getSkuPromotionListBySkuIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuPromotionListBySkuIds(["skuIds" => $skuIds]);
    }
    /**
     * 根据手机号获取用户信息
     * @return  array
    */
    public static function getUserInfo (string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo(["phone" => $phone]);
    }
    /**
     * 根据门店id和skuIds获取对应的库存
     * @return  mixed
    */
    public static function getStockBySkuIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockBySkuIds(["skuIds" => $skuIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}