<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 17:24:17
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 */
class User {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\User";

    /**
     * 获取用户基本信息
     * @return  mixed
    */
    public static function getUserInfoById (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoById(["user_id" => $user_id]);
    }
    /**
     * 获取用户优惠券
     * @return  mixed
    */
    public static function getUserCoupons (string $status = 'unused', int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["status" => $status, "user_id" => $user_id]);
    }
    /**
     * 获取用户历史订单数据
     * @return  mixed
    */
    public static function getHistoryOrderPageById (int $user_id, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryOrderPageById(["user_id" => $user_id, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取用户待提货产品
     * @return  mixed
    */
    public static function getUnverifiedGiftBox (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnverifiedGiftBox(["user_id" => $user_id]);
    }
    /**
     * 获取用户待领取权益
     * @return  mixed
    */
    public static function getWaitingWelfares (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitingWelfares(["user_id" => $user_id]);
    }
    /**
     * 根据手机号获取用户
     * @return  mixed
    */
    public static function getUserByPhone (string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserByPhone(["phone" => $phone]);
    }
    /**
     * 根据id获取用户
     * @return  mixed
    */
    public static function getUserById (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserById(["user_id" => $user_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}