<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-20 10:17:49
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\Store";

    /**
     * 根据分组获取门店(不传参数则为全部)
     */
    public static function all (string $classification, int $sc_id, bool $include_delete) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["classification" => $classification, "sc_id" => $sc_id, "include_delete" => $include_delete, ]);
    }
    /**
     * 获取门店信息
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 获取可用商场卡门店
     */
    public static function canUserMarketCardStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canUserMarketCardStore();
    }
    /**
     * 获取门店列表
     */
    public static function list (string $name, int $group_id, string $affiliate_type, int $province_id, int $city_id, int $area_id, int $city_type_id, string $store_type, string $status, int $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "group_id" => $group_id, "affiliate_type" => $affiliate_type, "province_id" => $province_id, "city_id" => $city_id, "area_id" => $area_id, "city_type_id" => $city_type_id, "store_type" => $store_type, "status" => $status, "page" => $page, ]);
    }
    /**
     * 查询子公司(不带分页)
     */
    public static function subcompanyAll (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->subcompanyAll(["id" => $id, "name" => $name, ]);
    }
    /**
     * 修改门店信息
     */
    public static function update (string $name, int $city_id, int $sc_id, int $province_id, int $group_id, int $id, string $affiliate_type, string $start_appointment_time, string $stop_appointment_time, int $service_times,  $extend, int $sort, string $use_pos_status, string $dianping_id, int $dept_id, string $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["name" => $name, "city_id" => $city_id, "sc_id" => $sc_id, "province_id" => $province_id, "group_id" => $group_id, "id" => $id, "affiliate_type" => $affiliate_type, "start_appointment_time" => $start_appointment_time, "stop_appointment_time" => $stop_appointment_time, "service_times" => $service_times, "extend" => $extend, "sort" => $sort, "use_pos_status" => $use_pos_status, "dianping_id" => $dianping_id, "dept_id" => $dept_id, "store_type" => $store_type, ]);
    }
    /**
     * 钉钉审批回调
     */
    public static function reviewCallback () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewCallback();
    }
    /**
     * 根据区域类型获取门店分类列表
     */
    public static function storeClassificationList (string $type = 'price_area') {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeClassificationList(["type" => $type, ]);
    }
    /**
     * 集团列表
     */
    public static function getGroups (int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroups(["page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 查询
     */
    public static function insuranceDetail (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->insuranceDetail(["store_id" => $store_id, ]);
    }
    /**
     * 获取部门列表
     */
    public static function getDepartmentList (string $type, bool $no_bind_store) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentList(["type" => $type, "no_bind_store" => $no_bind_store, ]);
    }
    /**
     * 获取美团对应店铺列表
     */
    public static function getMeituanStoreList (string $storeType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMeituanStoreList(["storeType" => $storeType, ]);
    }
    /**
     * 查询门店租金
     */
    public static function rentalDetail (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rentalDetail(["store_id" => $store_id, ]);
    }
    /**
     * 查询区域列表
     */
    public static function areaTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->areaTree();
    }
    /**
     * 获取拍摄成员信息配置
     */
    public static function getPhotographyMemberSetting (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographyMemberSetting();
    }
    /**
     * 是否是试点门店
     */
    public static function isPhotographyMemberExperiments (int $storeId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isPhotographyMemberExperiments(["storeId" => $storeId, ]);
    }
    /**
     * 申请闭店
     */
    public static function applyCloseStore (\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\CMD\Store\ApplyStoreCmd $applyStoreCmd): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->applyCloseStore($applyStoreCmd);
    }
    /**
     * 开始营业
     */
    public static function openStore (\Mainto\Bridge\Structs\HimoProductStore\Controllers\Admin\CMD\Store\OpenStoreCmd $openStoreCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->openStore($openStoreCmd);
    }
    /**
     * 定时任务 每天凌晨执行闭/开店操作
     */
    public static function cronApplyCloseStore (int $storeId = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronApplyCloseStore(["storeId" => $storeId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}