<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-22 20:02:17
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Paperless
 */
class Paperless {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "NoPaper\\Paperless";

    /**
     * 获取伙伴已通关产品id列表
     */
    public static function getPassProductIds (array $staffIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPassProductIds(["staffIds" => $staffIds, ]);
    }
    /**
     * 获取指定会员的历史订单数据
     */
    public static function getHistoryOrderPageById (int $page = 1, int $pageSize = 10, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryOrderPageById(["page" => $page, "pageSize" => $pageSize, "user_id" => $user_id, ]);
    }
    /**
     * 获取用户基本信息
     */
    public static function getUserInfo (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo(["user_id" => $user_id, ]);
    }
    /**
     * 获取用户优惠券
     */
    public static function getUserCoupons (string $status = 'unused', int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["status" => $status, "user_id" => $user_id, ]);
    }
    /**
     * 获取用户待提货产品
     */
    public static function getUserUnverifiedGiftBox (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserUnverifiedGiftBox(["user_id" => $user_id, ]);
    }
    /**
     * 获取用户待领取权益
     */
    public static function getUserWaitingWelfares (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserWaitingWelfares(["user_id" => $user_id, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}