<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-18 14:38:42
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCardOrder
 */
class ProductCardOrder {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\ProductCardOrder";

    /**
     * 获取产品卡订单列表
     *
     */
    public static function list (string $phone, string $user_name, string $create_start_at, string $create_end_at, string $pay_type, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["phone" => $phone, "user_name" => $user_name, "create_start_at" => $create_start_at, "create_end_at" => $create_end_at, "pay_type" => $pay_type, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 产品卡订单录入
     *
     */
    public static function input (string $user_name, string $phone, string $sex, string $pay_type, float $ori_money, float $pay_money, array $card_ids, string $type, array $extend, string $buy_channel, int $sale_store_id, bool $use_pos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->input(["user_name" => $user_name, "phone" => $phone, "sex" => $sex, "pay_type" => $pay_type, "ori_money" => $ori_money, "pay_money" => $pay_money, "card_ids" => $card_ids, "type" => $type, "extend" => $extend, "buy_channel" => $buy_channel, "sale_store_id" => $sale_store_id, "use_pos" => $use_pos, ]);
    }
    /**
     * 产品卡订单详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 可售产品卡列表
     *
     */
    public static function canSaleCardList (int $store_id, int $tock_operate_id, int $template_id, int $card_id, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canSaleCardList(["store_id" => $store_id, "tock_operate_id" => $tock_operate_id, "template_id" => $template_id, "card_id" => $card_id, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取产品卡模板列表(所有)
     *
     */
    public static function all (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name, ]);
    }
    /**
     * 计算产品卡价格 
     *
     */
    public static function calProductCardsPrice (array $cardIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductCardsPrice(["cardIds" => $cardIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}