<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-18 14:36:44
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Stock
 */
class Stock {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Erp\\Stock";

    /**
     * 库存列表
     *
     */
    public static function getStockList (string $locType, string $materialName, int $stockTaking = 1, int $page = 1, int $pageSize = 5): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockList(["locType" => $locType, "materialName" => $materialName, "stockTaking" => $stockTaking, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * getStockBySkusAndStoreId
     *
     */
    public static function getStockBySkusAndStoreId (array $skuIds, int $storeId, int $locType): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockBySkusAndStoreId(["skuIds" => $skuIds, "storeId" => $storeId, "locType" => $locType, ]);
    }
    /**
     * 出入库记录查询
     *
     */
    public static function getStockRecord (string $startTime, string $endTime, string $materialName, string $staffId, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockRecord(["startTime" => $startTime, "endTime" => $endTime, "materialName" => $materialName, "staffId" => $staffId, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 自动同步每个门店的固定资产数据
     *
     */
    public static function syncFixedAsset (string $asset_number): void {
         RpcClass::getClass(self::$serviceName, self::$className)->syncFixedAsset(["asset_number" => $asset_number, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}