<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-30 10:27:02
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AfterSale
 */
class AfterSale {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Retail\\AfterSale";

    /**
     * 售后单创建页面 - 获取零售订单商品明细
     *
     */
    public static function getAfterSaleOrderDetail (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleOrderDetail(["orderId" => $orderId, ]);
    }
    /**
     * 创建售后单
     *
     */
    public static function create (int $orderId, string $type, array $refundItemDetail, string $reason, string $note, int $confirmReturnInvoice, float $money, string $people, string $account, int $isStaffPay = 0, array $staffPayCertificate, string $from, int $inputStaffId, int $createType = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "type" => $type, "refundItemDetail" => $refundItemDetail, "reason" => $reason, "note" => $note, "confirmReturnInvoice" => $confirmReturnInvoice, "money" => $money, "people" => $people, "account" => $account, "isStaffPay" => $isStaffPay, "staffPayCertificate" => $staffPayCertificate, "from" => $from, "inputStaffId" => $inputStaffId, "createType" => $createType, ]);
    }
    /**
     * 根据售后单id关闭售后单
     *
     */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, ]);
    }
    /**
     * 根据零售订单id获取零售 - 售后单
     *
     */
    public static function afterSale (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSale(["orderId" => $orderId, ]);
    }
    /**
     * 根据售后单id，重新提交售后单
     *
     */
    public static function resubmit (int $id, string $people, string $account, int $isStaffPay, array $staffPayCertificate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmit(["id" => $id, "people" => $people, "account" => $account, "isStaffPay" => $isStaffPay, "staffPayCertificate" => $staffPayCertificate, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}