<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotographicNumByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method createCloudProductByParams(array $params)
 * @method enableCloudProductByParams(array $params)
 * @method photoLimitByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取摄影数量
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  int $service_id 服务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotographicNum (int $product_id, int $service_id = 0) {
        return self::getClass()->getPhotographicNum([
            "product_id" => $product_id,
            "service_id" => $service_id,
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryInfo (int $order_id) {
        return self::getClass()->getHistoryInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 创建云端产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCloudProduct (int $product_id) {
        return self::getClass()->createCloudProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 启用云端产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableCloudProduct (int $product_id) {
        return self::getClass()->enableCloudProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取图片限制
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLimit () {
        return self::getClass()->photoLimit();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}