<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method cancelByParams(array $params)
 * @method getBaseRetakeInfoByParams(array $params)
 */
class Retake {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建重拍订单
     *
     * @support  string $userSex 用户性别 require false
     * @support  int $orderId 订单id require false
     * @support  int $storeId 重拍门店id require false
     * @support  int $peopleNum 订单到店人数（重拍商品的最大人数） require false
     * @support  double $money 订单总价 require false
     * @support  double $realMoney 订单实付金额 require false
     * @support  array $productInfo 订单详情 require false
     * @support  array $retakeSkuIds 重拍的拍摄产品id require false
     * @support  string $reserveTime 预约时间 require false
     * @support  string $reason 重拍原因 require false
     * @support  array $reasonIds 重拍原因ids require false
     * @support  string $note 备注 require false
     * @support  array $extend 订单extend require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 取消重拍订单
     *
     * @support  int $retakeOrderId 重拍的订单id require false
     * @support  string $reason 取消原因 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 获取重拍订单的基础信息
     *
     * @support  int $orderId 原订单id require false
     * @support  int $retakeOrderId 重拍的订单id require false
     * @support  string $status 订单状态 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBaseRetakeInfo () {
        return self::getClass()->getBaseRetakeInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Retake');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Retake');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}