<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method historyListByParams(array $params)
 * @method giveByParams(array $params)
 * @method giveCouponTypeListByParams(array $params)
 */
class GiveCoupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 赠券列表
     *
     * @support  string $order_no 订单号 require false
     * @support  string $user_name 下单用户姓名 require false
     * @support  string $user_phone 手机号 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 条数 require false
     * @support  bool $all_store 是否查询所有门店 require false
     * @support  string $sort_field 排序字段 require false
     * @support  bool $sort_desc 是否倒序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 赠送记录
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function historyList () {
        return self::getClass()->historyList();
    }

    /**
     * 赠送
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $type 赠送类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function give () {
        return self::getClass()->give();
    }

    /**
     * 获取赠送券的类型列表
     *
     * @support  string $storeType 门店类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveCouponTypeList () {
        return self::getClass()->giveCouponTypeList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\GiveCoupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\GiveCoupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}