<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-06 16:46:18
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductStore
 */
class ProductStore {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\ProductStore";

    /**
     * 获取门店所有产品
     *
     */
    public static function storeProduct (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeProduct(["storeId" => $storeId, ]);
    }
    /**
     * 获取产品详情
     *
     */
    public static function info (int $product_id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["product_id" => $product_id, "store_id" => $store_id, ]);
    }
    /**
     * 批量获取多个产品详情
     *
     */
    public static function batchDetail (array $product_ids, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDetail(["product_ids" => $product_ids, "store_id" => $store_id, ]);
    }
    /**
     * 获取产品/服务详情
     *
     */
    public static function storeProductDetail (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeProductDetail(["product_id" => $product_id, ]);
    }
    /**
     * 获取门店折扣规则
     *
     */
    public static function getStoreDiscount (int $store_id, bool $add_hour) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreDiscount(["store_id" => $store_id, "add_hour" => $add_hour, ]);
    }
    /**
     * 获取门店产品可选衣服
     *
     */
    public static function getProductCloth (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCloth(["product_id" => $product_id, ]);
    }
    /**
     * testclearcache
     *
     */
    public static function testClearCache (string $key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->testClearCache(["key" => $key, ]);
    }
    /**
     * 2020圣诞照配置
     *
     */
    public static function christmasActivitySetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->christmasActivitySetting();
    }
    /**
     * 圣诞照Mix产品拆分
     *
     */
    public static function unpackChristmasMix (int $storeId, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unpackChristmasMix(["storeId" => $storeId, "detail" => $detail, ]);
    }
    /**
     * 获取全产品宫格别名
     *
     */
    public static function getGonggeAlias () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGonggeAlias();
    }
    /**
     * 根据价格区和产品id获取产品的可用价格
     *
     */
    public static function getProductAvailablePrice (int $priceAreaId, int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductAvailablePrice(["priceAreaId" => $priceAreaId, "productId" => $productId, ]);
    }
    /**
     * 通过拍摄产品ids获取零售产品信息
     *
     */
    public static function getRetailProductListByProductIds (int $storeId, array $productIds): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailProductListByProductIds(["storeId" => $storeId, "productIds" => $productIds, ]),
            "\Mainto\Bridge\Structs\HimoProductStore\Admin\RetailProduct\Dto\RetailProductDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}