<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-25 13:48:04
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderRefund
 */
class OrderRefund {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\OrderRefund";

    /**
     * 预约退款录入
     *
     */
    public static function create (int $order_id, string $refund_type, array $refund_info, int $scale, string $people, string $account, array $reason_ids, string $reason, bool $is_staff_pay, int $priority_refund_gift_card, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["order_id" => $order_id, "refund_type" => $refund_type, "refund_info" => $refund_info, "scale" => $scale, "people" => $people, "account" => $account, "reason_ids" => $reason_ids, "reason" => $reason, "is_staff_pay" => $is_staff_pay, "priority_refund_gift_card" => $priority_refund_gift_card, "note" => $note, ]);
    }
    /**
     * 退款列表
     *
     */
    public static function list (string $order_no, string $status, string $brand, string $status_list, int $store_id, array $store_ids, string $pay_type, string $apply_time_start, string $apply_time_end, string $process_time_start, string $process_time_end, string $complete_time_start, string $complete_time_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["order_no" => $order_no, "status" => $status, "brand" => $brand, "status_list" => $status_list, "store_id" => $store_id, "store_ids" => $store_ids, "pay_type" => $pay_type, "apply_time_start" => $apply_time_start, "apply_time_end" => $apply_time_end, "process_time_start" => $process_time_start, "process_time_end" => $process_time_end, "complete_time_start" => $complete_time_start, "complete_time_end" => $complete_time_end, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 退款详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 退款理由
     *
     */
    public static function reason (string $category, int $parent_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reason(["category" => $category, "parent_id" => $parent_id, ]);
    }
    /**
     * 快速退款至礼品卡
     *
     */
    public static function fastRefundToGiftCard (int $order_id, string $refund_type, array $refund_info, string $people, string $reason, bool $is_staff_pay, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fastRefundToGiftCard(["order_id" => $order_id, "refund_type" => $refund_type, "refund_info" => $refund_info, "people" => $people, "reason" => $reason, "is_staff_pay" => $is_staff_pay, "note" => $note, ]);
    }
    /**
     * 获取部分子订单项可退金额
     *
     */
    public static function canRefundDetailByIds (int $order_id, array $refund_info, string $refund_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefundDetailByIds(["order_id" => $order_id, "refund_info" => $refund_info, "refund_type" => $refund_type, ]);
    }
    /**
     * 根据订单的拍摄产品获取可退信息
     *
     */
    public static function calcRefundInfoByOrderItems (int $orderId, string $refundType, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calcRefundInfoByOrderItems(["orderId" => $orderId, "refundType" => $refundType, "refundInfo" => $refundInfo, ]);
    }
    /**
     * 创建特殊部分退款申请并处理
     *
     */
    public static function createSpecialRefundAndConfirm (int $orderId, string $refundType, string $refundMoneyType, float $refundMoney, string $people, string $account, string $reason, array $reasonIds, string $note, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpecialRefundAndConfirm(["orderId" => $orderId, "refundType" => $refundType, "refundMoneyType" => $refundMoneyType, "refundMoney" => $refundMoney, "people" => $people, "account" => $account, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "refundInfo" => $refundInfo, ]);
    }
    /**
     * 退款申请并处理v2
     *
     */
    public static function createAndConfirmV2 (int $orderId, string $refundType, int $scale, string $people, string $account, string $reason, array $reasonIds, string $note, array $refundInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndConfirmV2(["orderId" => $orderId, "refundType" => $refundType, "scale" => $scale, "people" => $people, "account" => $account, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "refundInfo" => $refundInfo, ]);
    }
    /**
     * 可转退列表
     *
     */
    public static function canRefundChangeList (string $order_no, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefundChangeList(["order_no" => $order_no, "type" => $type, ]);
    }
    /**
     * 创建转退
     *
     */
    public static function refundChangeCreate (int $refund_id, string $people, string $account, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundChangeCreate(["refund_id" => $refund_id, "people" => $people, "account" => $account, "reason" => $reason, ]);
    }
    /**
     * 退款申请并处理
     *
     */
    public static function createAndConfirm (int $order_id, string $refund_type, array $refund_info, int $scale, string $people, string $account, array $reason_ids, string $reason, bool $is_staff_pay, int $priority_refund_gift_card, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndConfirm(["order_id" => $order_id, "refund_type" => $refund_type, "refund_info" => $refund_info, "scale" => $scale, "people" => $people, "account" => $account, "reason_ids" => $reason_ids, "reason" => $reason, "is_staff_pay" => $is_staff_pay, "priority_refund_gift_card" => $priority_refund_gift_card, "note" => $note, ]);
    }
    /**
     * 修改信息
     *
     */
    public static function fixRefundAccount (int $id, string $people, string $account) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixRefundAccount(["id" => $id, "people" => $people, "account" => $account, ]);
    }
    /**
     * 获取订单退款信息
     *
     */
    public static function getOrderRefundInfo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderRefundInfo(["order_no" => $order_no, ]);
    }
    /**
     * 删除转退
     *
     */
    public static function remove (int $refund_change_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["refund_change_id" => $refund_change_id, ]);
    }
    /**
     * handleOrderRefundWithRetail
     *
     */
    public static function handleOrderRefundWithRetail (int $orderId, string $refundType, array $refundInfo, int $scale, string $people, string $account, array $reasonIds, string $reason, bool $isStaffPay, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleOrderRefundWithRetail(["orderId" => $orderId, "refundType" => $refundType, "refundInfo" => $refundInfo, "scale" => $scale, "people" => $people, "account" => $account, "reasonIds" => $reasonIds, "reason" => $reason, "isStaffPay" => $isStaffPay, "note" => $note, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}