<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-20 16:12:05
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Admin\\Order";

    /**
     * 订单列表查询
     *
     */
    public static function list (string $orderNo, string $reserveTimeStart, string $reserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $status, string $statusList, string $userName, string $userPhone, int $userId, bool $allStore, bool $isHangUp, int $page, int $pageSize, string $sortField, bool $sortDesc, string $search) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderNo" => $orderNo, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "status" => $status, "statusList" => $statusList, "userName" => $userName, "userPhone" => $userPhone, "userId" => $userId, "allStore" => $allStore, "isHangUp" => $isHangUp, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "search" => $search, ]);
    }
    /**
     * 获取订单详情
     *
     */
    public static function detail (int $id, string $orderNo, bool $orderPhoneDesensitization, bool $withDelete, bool $withRefund, bool $checkedStudentMember) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo, "orderPhoneDesensitization" => $orderPhoneDesensitization, "withDelete" => $withDelete, "withRefund" => $withRefund, "checkedStudentMember" => $checkedStudentMember, ]);
    }
    /**
     * 获取订单详情V2
     *
     */
    public static function detailV2 (int $id, string $orderNo, bool $withDelete, bool $withRefund, bool $checkedStudentMember, bool $withModifyRefund, bool $withTurnover): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailV2(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withRefund" => $withRefund, "checkedStudentMember" => $checkedStudentMember, "withModifyRefund" => $withModifyRefund, "withTurnover" => $withTurnover, ]);
    }
    /**
     * 核销订单
     *
     */
    public static function verifyOrder (int $order_id, string $activity_type, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifyOrder(["order_id" => $order_id, "activity_type" => $activity_type, "type" => $type, ]);
    }
    /**
     * 核销订单赠品
     *
     */
    public static function verifyOrderGift (int $order_id, int $order_verification_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifyOrderGift(["order_id" => $order_id, "order_verification_id" => $order_verification_id, ]);
    }
    /**
     * 通过订单号获取订单详情
     *
     */
    public static function detailByNum (string $order_num, bool $with_del) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNum(["order_num" => $order_num, "with_del" => $with_del, ]);
    }
    /**
     * 修改外拍订单地址
     *
     */
    public static function changeAddress (int $id, string $outsideCity, string $outsideAddress) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeAddress(["id" => $id, "outsideCity" => $outsideCity, "outsideAddress" => $outsideAddress, ]);
    }
    /**
     * 设置拍摄成员信息
     *
     */
    public static function setPhotoPeoples (int $orderId, array $photoPeoples): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoPeoples(["orderId" => $orderId, "photoPeoples" => $photoPeoples, ]);
    }
    /**
     * 设置订单下产品拍摄成员
     *
     */
    public static function setSalePhotoPeoples (int $orderId, array $salePeoplePhotos): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setSalePhotoPeoples(["orderId" => $orderId, "salePeoplePhotos" => $salePeoplePhotos, ]);
    }
    /**
     * 获取订单下产品拍摄成员
     *
     */
    public static function getSalePhotoPeoples (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSalePhotoPeoples(["orderId" => $orderId, ]);
    }
    /**
     * 创建订单
     *
     */
    public static function create (int $userId, string $userName, string $userPhone, string $userSex, string $userEmail, string $userBirthday, float $money, float $realMoney, array $productInfo, int $reachedPeopleNum, string $interiorCouponCode, float $interiorCouponDeductionMoney, int $couponId, float $couponDeductionMoney, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, int $specialDiscountStaffId, string $discountNote, string $reserveTime, array $groupOrderItemIds, array $retailProducts, string $type, string $channel, string $note, string $outsideCity, string $outsideAddress, array $packageDiscountIds, float $packageDiscountMoney, float $weekdayDiscountMoney, array $maintoExtend, string $paymentMethod, float $depositMoney, float $balanceMoney, array $photoPeoples) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userEmail" => $userEmail, "userBirthday" => $userBirthday, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "reachedPeopleNum" => $reachedPeopleNum, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponId" => $couponId, "couponDeductionMoney" => $couponDeductionMoney, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "specialDiscountStaffId" => $specialDiscountStaffId, "discountNote" => $discountNote, "reserveTime" => $reserveTime, "groupOrderItemIds" => $groupOrderItemIds, "retailProducts" => $retailProducts, "type" => $type, "channel" => $channel, "note" => $note, "outsideCity" => $outsideCity, "outsideAddress" => $outsideAddress, "packageDiscountIds" => $packageDiscountIds, "packageDiscountMoney" => $packageDiscountMoney, "weekdayDiscountMoney" => $weekdayDiscountMoney, "maintoExtend" => $maintoExtend, "paymentMethod" => $paymentMethod, "depositMoney" => $depositMoney, "balanceMoney" => $balanceMoney, "photoPeoples" => $photoPeoples, ]);
    }
    /**
     * 获取创建订单中间参数
     *
     */
    public static function getParamsBeforeCreateOrder (int $userId, string $userName, string $userPhone, string $userSex, string $userBirthday, float $money, float $realMoney, array $productInfo, int $reachedPeopleNum, string $interiorCouponCode, float $interiorCouponDeductionMoney, int $couponId, float $couponDeductionMoney, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, int $specialDiscountStaffId, string $reserveTime, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParamsBeforeCreateOrder(["userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "reachedPeopleNum" => $reachedPeopleNum, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponId" => $couponId, "couponDeductionMoney" => $couponDeductionMoney, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "specialDiscountStaffId" => $specialDiscountStaffId, "reserveTime" => $reserveTime, "type" => $type, ]);
    }
    /**
     * 设置拍摄订单签到
     *
     */
    public static function userReached (int $orderId, int $reachedPeopleNum, bool $needMoney, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney, "money" => $money, ]);
    }
    /**
     * 修改拍摄订单签到
     *
     */
    public static function modifyUserReached (int $orderId, int $reachedPeopleNum, bool $needMoney, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyUserReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "needMoney" => $needMoney, "money" => $money, ]);
    }
    /**
     * 设置签到完成支付
     *
     */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, string $paymentNo, int $operateId, bool $fromPaymentGateway) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserReachedPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType, "paymentNo" => $paymentNo, "operateId" => $operateId, "fromPaymentGateway" => $fromPaymentGateway, ]);
    }
    /**
     * 拍摄签到详情
     *
     */
    public static function getUserReachedDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserReachedDetail(["orderId" => $orderId, ]);
    }
    /**
     * 绑定用户
     *
     */
    public static function bindUser (int $id, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUser(["id" => $id, "user_id" => $user_id, ]);
    }
    /**
     * 取消绑定用户
     *
     */
    public static function unbindUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindUser(["id" => $id, ]);
    }
    /**
     * 修改订单所属用户
     *
     */
    public static function updateUser (string $order_num, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUser(["order_num" => $order_num, "phone" => $phone, ]);
    }
    /**
     * 取消订单
     *
     */
    public static function cancel (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason, ]);
    }
    /**
     * 完成支付
     *
     */
    public static function paid (int $id, int $orderDiffId, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 零售完成支付（用于支付链接支付）
     *
     */
    public static function retailOrderSetPaid (int $id, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOrderSetPaid(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 开始订单
     *
     */
    public static function start (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->start(["id" => $id, ]);
    }
    /**
     * 关闭订单
     *
     */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, ]);
    }
    /**
     * 完成订单（拍摄完成）
     *
     */
    public static function finish (int $id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["id" => $id, "workloads" => $workloads, ]);
    }
    /**
     * 订单服务完成
     *
     */
    public static function orderServiceCompleted (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderServiceCompleted(["orderId" => $orderId, ]);
    }
    /**
     * 查询订单赠品
     *
     */
    public static function getOrderGift (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderGift(["orderId" => $orderId, ]);
    }
    /**
     * 查询订单工作量
     *
     */
    public static function getOrderWorkloads (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderWorkloads(["orderId" => $orderId, ]);
    }
    /**
     * 录入工作量
     *
     */
    public static function setOrderWorkloads (int $orderId, array $workloads, array $assigns): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderWorkloads(["orderId" => $orderId, "workloads" => $workloads, "assigns" => $assigns, ]);
    }
    /**
     * 修改预约时间
     *
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserve_time" => $reserve_time, ]);
    }
    /**
     * 修改用户数据
     *
     */
    public static function changeUserData (int $id, string $user_name, string $user_sex, string $user_email) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "user_name" => $user_name, "user_sex" => $user_sex, "user_email" => $user_email, ]);
    }
    /**
     * 删除订单
     *
     */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, ]);
    }
    /**
     * 用户可用优惠券列表
     *
     */
    public static function getCanUseCouponList (array $product_group_ids, array $product_ids, array $service_product_ids, int $user_id, int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseCouponList(["product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "service_product_ids" => $service_product_ids, "user_id" => $user_id, "order_id" => $order_id, ]);
    }
    /**
     * 用户可用产品卡列表
     *
     */
    public static function getCanUseProductCardList (array $product_group_ids, array $product_ids, array $package_ids, array $service_product_ids, int $user_id, int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanUseProductCardList(["product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "package_ids" => $package_ids, "service_product_ids" => $service_product_ids, "user_id" => $user_id, "order_id" => $order_id, ]);
    }
    /**
     * 获取修改预约时间订单优惠发生变化信息
     *
     */
    public static function getOrderDiscountChangeInfo (int $orderId, string $reserveTime): \Mainto\Bridge\Structs\HimoProductStore\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderDiscountChangeInfo(["orderId" => $orderId, "reserveTime" => $reserveTime, ]),
            "\Mainto\Bridge\Structs\HimoProductStore\Admin\Order\Dto\GetOrderDiscountChangeInfoDTO"
        );
    }
    /**
     * 获取订单可用优惠券
     *
     */
    public static function getOrderJxjyCoupons (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderJxjyCoupons(["order_id" => $order_id, ]);
    }
    /**
     * 获取用户加修加印券
     *
     */
    public static function jxjyCoupon (int $user_id, array $product_group_ids, array $product_ids, int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->jxjyCoupon(["user_id" => $user_id, "product_group_ids" => $product_group_ids, "product_ids" => $product_ids, "order_id" => $order_id, ]);
    }
    /**
     * 获取优惠券详情
     *
     */
    public static function getCouponInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponInfo(["id" => $id, ]);
    }
    /**
     * 获取产品券详情
     *
     */
    public static function getProductCardInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardInfo(["id" => $id, ]);
    }
    /**
     * 计算优惠券可抵扣信息
     *
     */
    public static function calCouponDeductionInfo (array $detail, int $coupon_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calCouponDeductionInfo(["detail" => $detail, "coupon_id" => $coupon_id, ]);
    }
    /**
     * 计算产品卡可抵扣信息
     *
     */
    public static function calProductDeductionInfo (array $detail, int $product_card_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calProductDeductionInfo(["detail" => $detail, "product_card_id" => $product_card_id, ]);
    }
    /**
     * 订单开单折扣码抵扣
     *
     */
    public static function calInteriorCouponDeductionInfo (string $interior_coupon_code, bool $verify_usability) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calInteriorCouponDeductionInfo(["interior_coupon_code" => $interior_coupon_code, "verify_usability" => $verify_usability, ]);
    }
    /**
     * 录入工作量
     *
     */
    public static function workloads (int $order_id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->workloads(["order_id" => $order_id, "workloads" => $workloads, ]);
    }
    /**
     * 检查订单用户是否关注公众号
     *
     */
    public static function checkUserSubscribe (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserSubscribe(["user_id" => $user_id, ]);
    }
    /**
     * 获取短链接
     *
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShortUrl(["order_num" => $order_num, "url" => $url, "pay_type" => $pay_type, ]);
    }
    /**
     * 发送付款链接
     *
     */
    public static function sendPayLink (int $orderId, string $url, string $phone, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPayLink(["orderId" => $orderId, "url" => $url, "phone" => $phone, "orderType" => $orderType, ]);
    }
    /**
     * 重置工作量
     *
     */
    public static function reset (int $order_id, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reset(["order_id" => $order_id, "workloads" => $workloads, ]);
    }
    /**
     * 工作量查询
     *
     */
    public static function workloadDetail (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->workloadDetail(["order_num" => $order_num, ]);
    }
    /**
     * 获取当日售卖产品总数
     *
     */
    public static function reserveProductCount (string $reserveTimeStart, string $reserveTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reserveProductCount(["reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 折扣列表
     *
     */
    public static function getProductDiscountByIds (string $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDiscountByIds(["ids" => $ids, ]);
    }
    /**
     * 管理端查询订单操作记录
     *
     */
    public static function operateLog (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateLog(["order_id" => $order_id, ]);
    }
    /**
     * 创建拉卡拉线下支付单
     *
     */
    public static function createPayMaxPayment (string $order_num, float $pay_money, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPayMaxPayment(["order_num" => $order_num, "pay_money" => $pay_money, "extend" => $extend, ]);
    }
    /**
     * 支付回调
     *
     */
    public static function payMaxCallback (string $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payMaxCallback(["data" => $data, ]);
    }
    /**
     * 支付回调测试
     *
     */
    public static function callBackTest (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBackTest(["data" => $data, ]);
    }
    /**
     * 校验美团大众券信息
     *
     */
    public static function prepare (string $receipt_code, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->prepare(["receipt_code" => $receipt_code, "store_id" => $store_id, ]);
    }
    /**
     * 创建美团大众点评支付单
     *
     */
    public static function createPayment (string $order_num, float $pay_money, string $receipt_code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPayment(["order_num" => $order_num, "pay_money" => $pay_money, "receipt_code" => $receipt_code, ]);
    }
    /**
     * 特殊产品ding门店伙伴
     *
     */
    public static function productDing (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDing(["orderId" => $orderId, ]);
    }
    /**
     * 修改使用礼品卡金额
     *
     */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useGiftCardMoney(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney, ]);
    }
    /**
     * 修改使用商场卡金额
     *
     */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useMarketCardMoney(["id" => $id, "marketCardMoney" => $marketCardMoney, ]);
    }
    /**
     * 使用礼品卡支付确认的推送
     *
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardPayDsConfirmPush(["id" => $id, "giftCardMoney" => $giftCardMoney, ]);
    }
    /**
     * 查账助手-根据订单类型获取
     *
     */
    public static function listByPay (string $orderType, string $type, string $status, string $statusList, string $payType, string $paidAtStart, string $paidAtEnd, string $pageSize, string $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listByPay(["orderType" => $orderType, "type" => $type, "status" => $status, "statusList" => $statusList, "payType" => $payType, "paidAtStart" => $paidAtStart, "paidAtEnd" => $paidAtEnd, "pageSize" => $pageSize, "page" => $page, ]);
    }
    /**
     * 获取临时二维码
     *
     */
    public static function getWxQrCode (string $key, string $expireSeconds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWxQrCode(["key" => $key, "expireSeconds" => $expireSeconds, ]);
    }
    /**
     * 获取打印订单信息
     *
     */
    public static function getPrintInfo (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPrintInfo(["orderId" => $orderId, ]);
    }
    /**
     * 是否可以退零售产品
     *
     */
    public static function canRefundRetailProduct (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefundRetailProduct(["orderId" => $orderId, ]);
    }
    /**
     * 零售是否可以提货
     *
     */
    public static function canDeliveryRetailProduct (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canDeliveryRetailProduct(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单正在编辑的状态
     *
     */
    public static function getOrderEditStatus (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderEditStatus(["orderId" => $orderId, ]);
    }
    /**
     * 发送故事征集邀请
     *
     */
    public static function sendStoryCollectInvite (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendStoryCollectInvite(["orderNo" => $orderNo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}