<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-20 17:45:53
 */
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetailOrder
 */
class RetailOrder {
    private static string $serviceName = "HimoProductStore";

    private static string $className = "Retail\\RetailOrder";

    /**
     * 订单详情
     *
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 订单详情【根据订单号获取】
     *
     */
    public static function detailByOrderNo (string $order_no): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByOrderNo(["order_no" => $order_no, ]);
    }
    /**
     * 订单列表
     *
     */
    public static function list (int $page, int $page_size, string $user_phone, string $paid_time_start, string $paid_time_end, string $user_name, string $order_no, string $pay_type, string $status, string $express_status, string $status_list) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "page_size" => $page_size, "user_phone" => $user_phone, "paid_time_start" => $paid_time_start, "paid_time_end" => $paid_time_end, "user_name" => $user_name, "order_no" => $order_no, "pay_type" => $pay_type, "status" => $status, "express_status" => $express_status, "status_list" => $status_list, ]);
    }
    /**
     * 使用礼品卡支付预付
     *
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendGiftCardPayDsConfirmPush(["id" => $id, "giftCardMoney" => $giftCardMoney, ]);
    }
    /**
     * 设置订单完成支付
     *
     */
    public static function setPaid (float $money, int $id, string $pay_type, string $payment_no, string $certificate, string $payment_time): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["money" => $money, "id" => $id, "pay_type" => $pay_type, "payment_no" => $payment_no, "certificate" => $certificate, "payment_time" => $payment_time, ]);
    }
    /**
     * 根据订单id，查询用户是否使用了礼品卡，和礼品卡使用了多少
     *
     */
    public static function getOrderGiftCardInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderGiftCardInfo(["id" => $id, ]);
    }
    /**
     * 关闭订单
     *
     */
    public static function close (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "reason" => $reason, ]);
    }
    /**
     * 修改用户数据
     *
     */
    public static function changeUserData (int $id, string $user_name, string $user_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "user_name" => $user_name, "user_phone" => $user_phone, ]);
    }
    /**
     * 根据订单号获取订单ID
     *
     */
    public static function getIdByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["order_no" => $order_no, ]);
    }
    /**
     * 根据订单ID获取订单号
     *
     */
    public static function getNoById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoById(["id" => $id, ]);
    }
    /**
     * 根据订单号获取订单下面买的产品
     *
     */
    public static function getProductsInOrder (string $order_no, int $order_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrder(["order_no" => $order_no, "order_id" => $order_id, ]);
    }
    /**
     * 根据订单号批量获取订单下面买的产品
     *
     */
    public static function getProductsInOrders (array $order_nos, array $order_ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrders(["order_nos" => $order_nos, "order_ids" => $order_ids, ]);
    }
    /**
     * 获取零售产品促销订单信息
     *
     */
    public static function getRetailPromotionOrder (array $order_info, bool $is_staff, bool $use_staff_discount, int $orderId, int $id, bool $useActivity, string $phone, string $managerDiscountType, float $managerDiscountAmount): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailPromotionOrder(["order_info" => $order_info, "is_staff" => $is_staff, "use_staff_discount" => $use_staff_discount, "orderId" => $orderId, "id" => $id, "useActivity" => $useActivity, "phone" => $phone, "managerDiscountType" => $managerDiscountType, "managerDiscountAmount" => $managerDiscountAmount, ]);
    }
    /**
     * 根据活动获取促销商品列表
     *
     */
    public static function getPromotionProducts (int $promotion_id, string $name, int $is_giveaway, string $status, int $page, int $page_size): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPromotionProducts(["promotion_id" => $promotion_id, "name" => $name, "is_giveaway" => $is_giveaway, "status" => $status, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取促销活动详情
     *
     */
    public static function promotionDetail (int $promotion_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->promotionDetail(["promotion_id" => $promotion_id, ]);
    }
    /**
     * 完成自提
     *
     */
    public static function finishExpress (int $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishExpress(["itemId" => $itemId, ]);
    }
    /**
     * 批量完成自提
     *
     */
    public static function batchFinishExpress (array $itemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchFinishExpress(["itemIds" => $itemIds, ]);
    }
    /**
     * 撤销自提
     *
     */
    public static function cancelExpress (int $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelExpress(["itemId" => $itemId, ]);
    }
    /**
     * 批量撤销自提
     *
     */
    public static function batchCancelExpress (array $itemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCancelExpress(["itemIds" => $itemIds, ]);
    }
    /**
     * 修改订单的状态
     *
     */
    public static function changeOrderStatus (int $id, string $status, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeOrderStatus(["id" => $id, "status" => $status, "operateId" => $operateId, ]);
    }
    /**
     * 检测是否可以参与圣诞活动
     *
     */
    public static function checkActivityCond (int $orderId, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkActivityCond(["orderId" => $orderId, "id" => $id, ]);
    }
    /**
     * 查询订单操作日志
     *
     */
    public static function log (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->log(["id" => $id, ]);
    }
    /**
     * 根据零售订单id查询发票信息
     *
     */
    public static function invoice (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoice(["id" => $id, ]);
    }
    /**
     * 通过零售订单号获取提货码
     *
     */
    public static function getVerifySelfCode (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getVerifySelfCode(["order_no" => $order_no, ]);
    }
    /**
     * 通过核销取件码，获取零售自提订单核销相关的信息
     *
     */
    public static function verifySelfOrder (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifySelfOrder(["code" => $code, ]);
    }
    /**
     * 通过核销取件码，设置核销完成，删除该取件码
     *
     */
    public static function verifySelfOrderRemove (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifySelfOrderRemove(["code" => $code, ]);
    }
    /**
     * 根据订单编号获取订单信息
     *
     */
    public static function getPriceInfoByNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPriceInfoByNo(["orderNo" => $orderNo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}