<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-12 16:44:02
 */
namespace Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command;

class CreateRefundCommand {
    /**
     * @var  int
     * 团购订单id
     * validation: 
     */
    public int $groupOrderId;
    /**
     * @var  string
     * 渠道
     * validation: in:store,business
     */
    public string $channel;
    /**
     * @var  float
     * 退款金额
     * validation: 
     */
    public float $refundMoney;
    /**
     * @var  string
     * 退款账户
     * validation: 
     */
    public string $receiptAccount;
    /**
     * @var  string
     * 收款人
     * validation: 
     */
    public string $receiptPeople;
    /**
     * @var  string
     * 开户银行
     * validation: 
     */
    public string $openingBank;
    /**
     * @var  null|string
     * 退款原因
     * validation: 
     */
    public ?string $reason;
    /**
     * @var  \Mainto\Bridge\Structs\HimoProductStore\GroupOrderRefund\Command\RefundGroupOrderItemCommand[]
     * 退款的团购商品信息
     * validation: 
     */
    public array $refundItems;

    public function __construct (int $groupOrderId, string $channel, float $refundMoney, int $inputStaffId, string $receiptAccount, string $receiptPeople, string $openingBank, ?string $reason, array $refundItems) {
        $this->groupOrderId = $groupOrderId;
        $this->channel = $channel;
        $this->refundMoney = $refundMoney;
        $this->inputStaffId = $inputStaffId;
        $this->receiptAccount = $receiptAccount;
        $this->receiptPeople = $receiptPeople;
        $this->openingBank = $openingBank;
        $this->reason = $reason;
        $this->refundItems = $refundItems;
    }

    public static function create(int $groupOrderId, string $channel, float $refundMoney, int $inputStaffId, string $receiptAccount, string $receiptPeople, string $openingBank, ?string $reason, array $refundItems): self {
        return new self($groupOrderId, $channel, $refundMoney, $inputStaffId, $receiptAccount, $receiptPeople, $openingBank, $reason, $refundItems);
    }

    public function setGroupOrderId(int $groupOrderId): self {
        $this->groupOrderId = $groupOrderId;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setRefundMoney(float $refundMoney): self {
        $this->refundMoney = $refundMoney;

        return $this;
    }

    public function setReceiptAccount(string $receiptAccount): self {
        $this->receiptAccount = $receiptAccount;

        return $this;
    }

    public function setReceiptPeople(string $receiptPeople): self {
        $this->receiptPeople = $receiptPeople;

        return $this;
    }

    public function setOpeningBank(string $openingBank): self {
        $this->openingBank = $openingBank;

        return $this;
    }

    public function setReason(?string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setRefundItems(array $refundItems): self {
        $this->refundItems = $refundItems;

        return $this;
    }
}