<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPayTypesByParams(array $params)
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method canSaleCardListByParams(array $params)
 * @method allByParams(array $params)
 */
class GiftCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡订单支付类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPayTypes () {
        return self::getClass()->getPayTypes();
    }

    /**
     * 获取礼品卡订单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  int $page 分页 [ require false ]
     * @support  int $page_size 分页条数 [ require false ]
     * @support  string $start_at 开始时间 [ require false ]
     * @support  string $end_at 结束时间 [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 礼品卡订单录入
     *
     * @support  string $user_name 用户名 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 性别 [ require true ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  float $pay_money 实付 [ require false ]
     * @support  float $ori_money 原始金额 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @support  array $card_ids 卡片ids [ require false ]
     * @support  string $buy_channel 购买渠道 [ require false ]
     * @support  int $sale_store_id 售卖门店ID [ require false ]
     * @support  bool $use_pos 是否使用拉卡拉支付 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 礼品卡订单详情
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 可售卖礼品卡列表
     *
     * @support  int $cover_id 封面ID [ require false ]
     * @support  int $tock_operate_id 卡id [ require false ]
     * @support  int $money 金额 [ require false ]
     * @support  int $card_id 卡ID [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canSaleCardList () {
        return self::getClass()->canSaleCardList([
        ]);
    }

    /**
     * 获取礼品卡卡面列表(全部)
     *
     * @support  int $topic_id 主题ids [ require false ]
     * @support  string $title 卡面标题 [ require false ]
     * @support  bool $has_topic_info 是否包含主题信息 [ require false ]
     * @support  bool $is_on_sale 是否在售 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\GiftCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\GiftCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}