<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method resendByParams(array $params)
 * @method invoiceListByParams(array $params)
 * @method invoiceSubjectByParams(array $params)
 * @method canInvoiceListByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开具发票
     *
     * @support  string $invoice_belong 发票归属(himo|gift_card|product_card|other) [ require false ]
     * @support  string $invoice_type 发票类型(paper|electronic) [ require false ]
     * @support  string $title_type 抬头类型(person|company) [ require false ]
     * @support  string $type 抬头类型(normal|professional) [ require false ]
     * @support  bool $is_now 是否立即开具 [ require false ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机 (开票成功会短信提醒购方) [ require false ]
     * @support  string $taxnum 购方税号(18/20位) [ require false ]
     * @support  array $order_nums 订单编号 [ require false ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $telephone 购方电话 [ require false ]
     * @support  string $address 购方地址 [ require false ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require false ]
     * @support  string $email 推送邮箱 [ require false ]
     * @support  string $message 备注信息 [ require false ]
     * @support  string $delivery_area 收货省市区信息 [ require false ]
     * @support  string $delivery_address 收货详细地址信息 [ require false ]
     * @support  string $delivery_people 收货人 [ require false ]
     * @support  string $delivery_phone 收货手机 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 电子发票列表
     *
     * @support  bool $is_electronic 是否是电子发票 [ require true ]
     * @support  string $invoke_type 发票类型 [ require false ]
     * @support  string $start_time 开始时间 [ require false ]
     * @support  string $end_time 结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $title 抬头 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 电子发票重新发送
     *
     * @param  int $invoice_id 发票id [ require true ]
     * @param  string $phone 手机号 [ require false ]
     * @param  string $email 邮箱 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resend (int $invoice_id, string $phone = '', string $email = '') {
        return self::getClass()->resend([
            "invoice_id" => $invoice_id,
            "phone" => $phone,
            "email" => $email,
        ]);
    }

    /**
     * 可开发票订单列表
     *
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $order_num 订单号 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceList () {
        return self::getClass()->invoiceList([
        ]);
    }

    /**
     * 开票主体门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceSubject () {
        return self::getClass()->invoiceSubject();
    }

    /**
     * 各类订单可开发票订单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $type 订单类型 [ require true ]
     * @support  int $store_id 门店id [ require false ]
     * @support  bool $invoiced 是否已开票 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canInvoiceList () {
        return self::getClass()->canInvoiceList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}