<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStockListByParams(array $params)
 * @method getStockBySkusAndStoreIdByParams(array $params)
 * @method getStockRecordByParams(array $params)
 * @method syncFixedAssetByParams(array $params)
 * @method autoSyncSafetyStockByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 库存列表
     *
     * @support  string $locType 仓库 require false
     * @support  string $materialName 物料名称 require false
     * @param  uint $stockTaking 是否库存盘点 [ require true ]
     * @param  uint $page 页码 [ require true ]
     * @param  uint $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockList (int $page = 1, int $pageSize = 5, int $stockTaking = 1) {
        return self::getClass()->getStockList([
            "page" => $page,
            "pageSize" => $pageSize,
            "stockTaking" => $stockTaking,
        ]);
    }

    /**
     * getStockBySkusAndStoreId
     *
     * @param  array $skuIds skuIds [ require true ]
     * @support  uint $storeId storeId require false
     * @support  uint $locType locType require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStockBySkusAndStoreId (array $skuIds) {
        return self::getClass()->getStockBySkusAndStoreId([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 出入库记录查询
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $materialName 物料名称 require false
     * @support  string $staffId 员工工号 require false
     * @param  uint $page 页码 [ require true ]
     * @param  uint $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockRecord (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStockRecord([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 自动同步每个门店的固定资产数据
     *
     * @param  string $asset_number 资产编码 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function syncFixedAsset (string $asset_number) {
        return self::getClass()->syncFixedAsset([
            "asset_number" => $asset_number,
        ]);
    }

    /**
     * 同步安全库存
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoSyncSafetyStock () {
        return self::getClass()->autoSyncSafetyStock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}