<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeTrafficStatisticsByParams(array $params)
 * @method changeOrderUserInfoByParams(array $params)
 * @method changeOrderPayTypeByParams(array $params)
 * @method transferOrderDataByParams(array $params)
 * @method changeOrderExtendByParams(array $params)
 * @method changeDsPayTypeByParams(array $params)
 * @method callbackChangeOrderInfoByParams(array $params)
 * @method addNewUserByParams(array $params)
 * @method changUserInfoByParams(array $params)
 * @method getOrderInfoByOrderNumByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method changeUserPasswordByParams(array $params)
 * @method changeUserPasswordByMobileByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [管]门店流量统计(流量看板)
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @support  string $date 时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeTrafficStatistics (array $store_ids = []) {
        return self::getClass()->storeTrafficStatistics([
            "store_ids" => $store_ids,
        ]);
    }

    /**
     * 修改用户订单信息
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  string $user_name 订单用户名称 [ require true ]
     * @param  string $sex 订单用户性别 [ require true ]
     * @param  string $phone 订单联系方式人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderUserInfo (int $order_num = 0, string $user_name = '', string $sex = '', string $phone = '') {
        return self::getClass()->changeOrderUserInfo([
            "order_num" => $order_num,
            "user_name" => $user_name,
            "sex" => $sex,
            "phone" => $phone,
        ]);
    }

    /**
     * 修改订单的支付方式
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  int $pay_type 订单支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderPayType (int $order_num = 0, int $pay_type = 1) {
        return self::getClass()->changeOrderPayType([
            "order_num" => $order_num,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 专门店添加新的订单
     *
     * @param  array $order_data 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferOrderData (array $order_data = []) {
        return self::getClass()->transferOrderData([
            "order_data" => $order_data,
        ]);
    }

    /**
     * [管]修改订单扩展信息 -- 备注
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  array $order_data 订单备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderExtend (int $order_num = 0, array $order_data = []) {
        return self::getClass()->changeOrderExtend([
            "order_num" => $order_num,
            "order_data" => $order_data,
        ]);
    }

    /**
     * 修改二销的支付方式
     *
     * @param  array $update_ds_data 订单id [ require true ]
     * @param  array $delete_ds_data 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeDsPayType (array $update_ds_data = [], array $delete_ds_data = []) {
        return self::getClass()->changeDsPayType([
            "update_ds_data" => $update_ds_data,
            "delete_ds_data" => $delete_ds_data,
        ]);
    }

    /**
     * 支付回调修改订单信息
     *
     * @param  int $orderNum 订单id [ require true ]
     * @param  int $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callbackChangeOrderInfo (int $orderNum, int $payType) {
        return self::getClass()->callbackChangeOrderInfo([
            "orderNum" => $orderNum,
            "payType" => $payType,
        ]);
    }

    /**
     * 增加一条用户信息
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @param  string $openId 用户openid [ require true ]
     * @param  string $headImg 用户头像 [ require true ]
     * @param  int $sex 用户性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewUser (string $phone, string $password, string $openId = '', string $headImg = '', int $sex = 1) {
        return self::getClass()->addNewUser([
            "phone" => $phone,
            "password" => $password,
            "openId" => $openId,
            "headImg" => $headImg,
            "sex" => $sex,
        ]);
    }

    /**
     * changUserInfo
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $name 名字 [ require true ]
     * @param  string $birth 生日 [ require true ]
     * @param  string $address 地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserInfo (int $user_id, string $name = '', string $birth = '', string $address = '') {
        return self::getClass()->changUserInfo([
            "user_id" => $user_id,
            "name" => $name,
            "birth" => $birth,
            "address" => $address,
        ]);
    }

    /**
     * 根据订单号获取订单相关信息
     *
     * @param  int $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfoByOrderNum (int $orderNum) {
        return self::getClass()->getOrderInfoByOrderNum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 根据订单id获取订单详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改用户密码
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPassword (int $userId, string $password) {
        return self::getClass()->changeUserPassword([
            "userId" => $userId,
            "password" => $password,
        ]);
    }

    /**
     * 根据手机号修改用户密码
     *
     * @param  int $phone 用户手机号 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPasswordByMobile (int $phone, string $password) {
        return self::getClass()->changeUserPasswordByMobile([
            "phone" => $phone,
            "password" => $password,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}