<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OrderCompensationDto $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DetailDto $params)
 * @method operationLogDetailByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OperationLogDto $params)
 * @method terminateProcessByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\TerminateProcessDto $params)
 * @method sendSatisfactionSurveyByParams(array $params)
 * @method saveSatisfactionSurveyByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\SatisfactionSurveyDto $params)
 * @method orderCompensationReviewCallbackByParams(array $params)
 * @method saveOrderProcessInfoByParams(array|\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DingInstanceCacheDto $params)
 */
class OrderCompensation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后补偿订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OrderCompensationDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OrderCompensationDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 获取发起售后订单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DetailDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DetailResDto
     */
    public static function detail (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DetailDto $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($dto),
            "\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DetailResDto"
        );
    }


    /**
     * 获售后订单操作详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OperationLogDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationLogDetail (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\OperationLogDto $dto) {
        return self::getClass()->operationLogDetail($dto);
    }


    /**
     * 撤回售后赔偿订单申请
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\TerminateProcessDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateProcess (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\TerminateProcessDto $dto) {
        return self::getClass()->terminateProcess($dto);
    }


    /**
     * 发送售后评价消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSatisfactionSurvey () {
        return self::getClass()->sendSatisfactionSurvey();
    }

    /**
     * 保存售后评价消息
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\SatisfactionSurveyDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSatisfactionSurvey (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\SatisfactionSurveyDto $dto) {
        return self::getClass()->saveSatisfactionSurvey($dto);
    }


    /**
     * 钉钉审批结果回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderCompensationReviewCallback () {
        return self::getClass()->orderCompensationReviewCallback();
    }

    /**
     * bms发起售后补偿保存cache
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DingInstanceCacheDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveOrderProcessInfo (\Mainto\Bridge\Structs\HimoProductStore\Admin\OrderCompensation\Dto\DingInstanceCacheDto $dto) {
        return self::getClass()->saveOrderProcessInfo($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OrderCompensation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OrderCompensation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}