<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showByParams(array $params)
 * @method syncByParams(array $params)
 * @method fastSyncByParams(array $params)
 * @method showServicePassByParams(array $params)
 * @method syncServicePassByParams(array $params)
 * @method batchStaffProductsByParams(array $params)
 */
class StaffProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴通关产品详情
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function show () {
        return self::getClass()->show([
        ]);
    }

    /**
     * 同步伙伴的通关产品信息
     *
     * @support  array $staff_ids 伙伴ids [ require true ]
     * @support  array $product_ids 产品ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sync () {
        return self::getClass()->sync([
        ]);
    }

    /**
     * 快捷同步伙伴的通关产品信息
     *
     * @support  array $staff_ids 伙伴ids [ require true ]
     * @support  array $product_ids 产品ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fastSync () {
        return self::getClass()->fastSync([
        ]);
    }

    /**
     * 获取伙伴通关服务详情
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showServicePass () {
        return self::getClass()->showServicePass([
        ]);
    }

    /**
     * 同步伙伴的通关服务信息
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  bool $service_pass 服务是否通关 [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncServicePass () {
        return self::getClass()->syncServicePass([
        ]);
    }

    /**
     * 批量获取伙伴通关信息
     *
     * @param  array $staff_ids 伙伴ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchStaffProducts (array $staff_ids) {
        return self::getClass()->batchStaffProducts([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\StaffProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\StaffProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}