<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductByParams(array $params)
 * @method getStoreProductByParams(array $params)
 * @method getStoreHideProductByParams(array $params)
 */
class ProductTree {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 全部产品列表
     *
     * @support  int $category_id 类目id [ require false ]
     * @support  string $name 产品名(模糊查询) [ require false ]
     * @support  string $full_name 产品全名(模糊查询) [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @support  string $module 产品所属模块 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct([
        ]);
    }

    /**
     * 获取门店产品树
     *
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  int $show_level 产品层级 [ require false ]
     * @support  string $order_by_sort 排序:asc,desc [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  bool $c_hidden_retail 是否隐藏含有零售产品的套餐 [ require false ]
     * @support  bool $is_mainto_photography 是否是缦图摄影 [ require false ]
     * @support  bool $is_style 是否是缦图摄影 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreProduct () {
        return self::getClass()->getStoreProduct([
        ]);
    }

    /**
     * 获取门店隐藏产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreHideProduct () {
        return self::getClass()->getStoreHideProduct();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\ProductTree');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\ProductTree');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}