<?php
namespace Mainto\Bridge\Invokes\HimoProductStore;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method updateProductByParams(array $params)
 * @method packageUpByParams(array $params)
 * @method packageDownByParams(array $params)
 * @method updateCategoryByParams(array $params)
 * @method changeBlacklistByParams(array $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addProduct (int $productId) {
        return self::getClass()->addProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 修改产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProduct (int $productId) {
        return self::getClass()->updateProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 套餐上架
     *
     * @param  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function packageUp (int $packageId) {
        return self::getClass()->packageUp([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐下架
     *
     * @param  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function packageDown (int $packageId) {
        return self::getClass()->packageDown([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 分类变更
     *
     * @param  int $categoryId 分类id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCategory (int $categoryId) {
        return self::getClass()->updateCategory([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 产品禁用门店
     *
     * @param  array $storeIds 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeBlacklist (array $storeIds) {
        return self::getClass()->changeBlacklist([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}