<?php
namespace Mainto\Bridge\Invokes\HimoProductStore;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method removePackagesCacheByStoreIdByParams(array $params)
 * @method removeAllStorePackagesCacheByParams(array $params)
 * @method removeStoreProductCacheByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 清除门店套餐缓存
     *
     * @param  string $storeId storeId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removePackagesCacheByStoreId (string $storeId) {
        return self::getClass()->removePackagesCacheByStoreId([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 清除全部门店套餐缓存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeAllStorePackagesCache () {
        return self::getClass()->removeAllStorePackagesCache();
    }

    /**
     * 清除门店产品缓存
     *
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  int $show_level 产品层级 [ require false ]
     * @support  int $store_id 门店id [ require true ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  bool $c_hidden_retail 是否隐藏含有零售产品的套餐 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreProductCache () {
        return self::getClass()->removeStoreProductCache([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}