<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStockCountByParams(array $params)
 * @method submitByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method addInventoryStockRecordByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据类型获取物料数量
     *
     * @param  string $locType 仓库类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockCount (string $locType) {
        return self::getClass()->getStockCount([
            "locType" => $locType,
        ]);
    }

    /**
     * 提交盘点结果
     *
     * @support  int $id 盘点记录id [ require false ]
     * @param  int $staffId 员工工号 [ require true ]
     * @param  int $locType 盘点类型 [ require true ]
     * @param  array $materialInfo 物料信息 [ require true ]
     * @param  string $status 状态是否一致consistent [ require false ]
     * @param  string $applyIn 总部/门店 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $staffId, int $locType, array $materialInfo, string $status = 'consistent', string $applyIn = 'store') {
        return self::getClass()->submit([
            "staffId" => $staffId,
            "locType" => $locType,
            "materialInfo" => $materialInfo,
            "status" => $status,
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 盘点列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $locType 类型 [ require false ]
     * @support  string $staffId 操作人 [ require false ]
     * @support  string $applyIn 总部/门店 [ require false ]
     * @support  string $checkStatus 审核状态 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $inventoryId) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 盘点审核通过后,进行库存的同步操作
     *
     * @param  array $inventoryIds 盘点ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInventoryStockRecord (array $inventoryIds) {
        return self::getClass()->addInventoryStockRecord([
            "inventoryIds" => $inventoryIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}