<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method storeByParams(array $params)
 * @method detailByParams(array $params)
 * @method notEvaluateByParams(array $params)
 * @method editByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人nps数据统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id 员工id [ require false ]
     * @support  string $job 岗位类型 [ require false ]
     * @support  int $score 评价得分 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staff () {
        return self::getClass()->staff([
        ]);
    }

    /**
     * 门店nps数据统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $score 评分范围 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store([
        ]);
    }

    /**
     * 获取订单nps详情
     *
     * @support  int $order_id 订单id [ require false ]
     * @support  string $order_num 订单编号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 获取未评价nps的订单
     *
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function notEvaluate () {
        return self::getClass()->notEvaluate([
        ]);
    }

    /**
     * nps修改
     *
     * @support  int $id nps id [ require true ]
     * @support  int $all 总评分 [ require false ]
     * @support  int $receptionist 门市客服评分 [ require false ]
     * @support  int $cameraman 摄影师评分 [ require false ]
     * @support  int $retoucher 看片师评分 [ require false ]
     * @support  int $dresser 化妆师评分 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}