<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method inputByParams(array $params)
 * @method detailByParams(array $params)
 * @method canSaleCardListByParams(array $params)
 * @method allByParams(array $params)
 */
class ProductCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品卡订单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $create_start_at 开始时间 [ require false ]
     * @support  string $create_end_at 结束时间 [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  int $page 分页 [ require false ]
     * @support  int $page_size 分页 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 产品卡订单录入
     *
     * @support  string $user_name 用户名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 性别 [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  float $ori_money 原价金额 [ require true ]
     * @support  float $pay_money 实付 [ require true ]
     * @support  array $card_ids 卡片ids [ require false ]
     * @support  string $type 卡类型 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @support  string $buy_channel 购买渠道 [ require false ]
     * @support  int $sale_store_id 售卖门店ID [ require false ]
     * @support  bool $use_pos 是否使用拉卡拉支付 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function input () {
        return self::getClass()->input([
        ]);
    }

    /**
     * 产品卡订单详情
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 可售产品卡列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  int $tock_operate_id 卡id [ require false ]
     * @support  int $template_id 模板ID [ require false ]
     * @support  int $card_id 卡id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canSaleCardList () {
        return self::getClass()->canSaleCardList([
        ]);
    }

    /**
     * 获取产品卡模板列表(所有)
     *
     * @support  string $name 优惠名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\ProductCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\ProductCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}