<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByOrderNoByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method dingNotifyStaffEffectByParams(array $params)
 * @method getOrderGiftCardInfoByParams(array $params)
 * @method closeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method getRetailPromotionOrderByParams(array $params)
 * @method getPromotionProductsByParams(array $params)
 * @method promotionDetailByParams(array $params)
 * @method finishExpressByParams(array $params)
 * @method batchFinishExpressByParams(array $params)
 * @method cancelExpressByParams(array $params)
 * @method batchCancelExpressByParams(array $params)
 * @method changeOrderStatusByParams(array $params)
 * @method checkActivityCondByParams(array $params)
 * @method logByParams(array $params)
 * @method invoiceByParams(array $params)
 * @method getVerifySelfCodeByParams(array $params)
 * @method verifySelfOrderByParams(array $params)
 * @method verifySelfOrderRemoveByParams(array $params)
 * @method getPriceInfoByNoByParams(array $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $order_no 海马体订单号 [ require false ]
     * @support  int $himo_order_id 拍摄订单号 [ require false ]
     * @support  int $user_id 用户ID [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_phone 用户手机号 [ require false ]
     * @support  string $user_sex 用户性别 [ require false ]
     * @support  string $user_birthday 用户生日 [ require false ]
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  bool $is_staff 是否是内部员工 [ require false ]
     * @support  bool $use_staff_discount 是否使用员工优惠 [ require false ]
     * @support  bool $useActivity 使用圣诞活动 [ require false ]
     * @support  string $manager_discount_type 折扣类型 [ require false ]
     * @support  float $manager_discount_amount 折扣数值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑订单
     *
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $orderId 订单号 [ require false ]
     * @support  int $user_id 用户ID [ require false ]
     * @support  int $id 订单ID [ require false ]
     * @support  int $himo_order_id 拍摄订单号 [ require false ]
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_phone 用户手机号 [ require false ]
     * @support  string $user_sex 用户性别 [ require false ]
     * @support  string $user_birthday 用户生日 [ require false ]
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  string $from 订单来源（pc:管理端、mobile 预约端） [ require false ]
     * @support  bool $is_staff 是否是内部员工 [ require false ]
     * @support  bool $use_staff_discount 是否使用员工优惠 [ require false ]
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @support  bool $useActivity 使用圣诞活动 [ require false ]
     * @support  string $manager_discount_type 折扣类型 [ require false ]
     * @support  float $manager_discount_amount 折扣数值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByOrderNo (string $order_no) {
        return self::getClass()->detailByOrderNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 页内条数 [ require false ]
     * @support  string $user_phone 电话号码 [ require false ]
     * @support  string $paid_time_start 支付起始时间 [ require false ]
     * @support  string $paid_time_end 支付结束时间 [ require false ]
     * @support  string $user_name 用户姓名 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $express_status 自提状态 [ require false ]
     * @support  string $status_list 状态列表 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * todo 增加权限设置
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return self::getClass()->sendGiftCardPayDsConfirmPush([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  float $money 订单金额 [ require true ]
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require false ]
     * @param  string $certificate 支付凭证 [ require false ]
     * @param  string $payment_time 对公打款时间 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $pay_type, string $payment_no = '', string $certificate = '', string $payment_time = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
            "certificate" => $certificate,
            "payment_time" => $payment_time,
        ]);
    }

    /**
     * 发送零售业绩钉钉消息)
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingNotifyStaffEffect (int $id) {
        return self::getClass()->dingNotifyStaffEffect([
            "id" => $id,
        ]);
    }

    /**
     * todo 鉴权
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderGiftCardInfo (int $id) {
        return self::getClass()->getOrderGiftCardInfo([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_phone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData([
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     *
     * @param  string $order_no 订单号 [ require false ]
     * @param  int $order_id 订单ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder (string $order_no = null, int $order_id = null) {
        return self::getClass()->getProductsInOrder([
            "order_no" => $order_no,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     *
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  array $order_ids 订单ID数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders (array $order_nos = [], array $order_ids = []) {
        return self::getClass()->getProductsInOrders([
            "order_nos" => $order_nos,
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 获取零售产品促销订单信息
     *
     * @support  array $order_info 订单信息 [ require true ]
     * @support  bool $is_staff 是否是内部员工 [ require false ]
     * @support  bool $use_staff_discount 是否使用员工优惠 [ require false ]
     * @support  int $orderId 拍摄订单id [ require false ]
     * @support  int $id 零售订单id [ require false ]
     * @support  bool $useActivity 是否使用圣诞活动 [ require false ]
     * @support  string $phone 手机号 [ require false ]
     * @support  string $managerDiscountType 折扣类型 [ require false ]
     * @support  float $managerDiscountAmount 折扣数值 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetailPromotionOrder () {
        return self::getClass()->getRetailPromotionOrder([
        ]);
    }

    /**
     * 根据活动获取促销商品列表
     *
     * @support  int $promotion_id 活动ID [ require true ]
     * @support  string $name 订单信息 [ require false ]
     * @support  int $is_giveaway 是否是赠品:0 否 1 是 [ require false ]
     * @support  string $status 是否是上架商品: on 已上架商品 off 未上架商品 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPromotionProducts () {
        return self::getClass()->getPromotionProducts([
        ]);
    }

    /**
     * 获取促销活动详情
     *
     * @support  int $promotion_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function promotionDetail () {
        return self::getClass()->promotionDetail([
        ]);
    }

    /**
     * 完成自提
     *
     * @support  int $itemId 订单itemId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishExpress () {
        return self::getClass()->finishExpress([
        ]);
    }

    /**
     * 批量完成自提
     *
     * @support  array $itemIds 订单itemIds [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchFinishExpress () {
        return self::getClass()->batchFinishExpress([
        ]);
    }

    /**
     * 撤销自提
     *
     * @support  int $itemId 订单itemId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelExpress () {
        return self::getClass()->cancelExpress([
        ]);
    }

    /**
     * 批量撤销自提
     *
     * @support  array $itemIds 订单itemIds [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCancelExpress () {
        return self::getClass()->batchCancelExpress([
        ]);
    }

    /**
     * 修改订单的状态
     *
     * @support  int $id id [ require true ]
     * @support  string $status 订单状态: submitted(未支付)，paid(已支付) [ require false ]
     * @support  int $operateId 录入伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderStatus () {
        return self::getClass()->changeOrderStatus([
        ]);
    }

    /**
     * 检测是否可以参与圣诞活动
     *
     * @param  int $orderId 拍摄订单id [ require true ]
     * @param  int $id 零售订单id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkActivityCond (int $orderId, int $id = 0) {
        return self::getClass()->checkActivityCond([
            "orderId" => $orderId,
            "id" => $id,
        ]);
    }

    /**
     * 查询订单操作日志
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function log (int $id) {
        return self::getClass()->log([
            "id" => $id,
        ]);
    }

    /**
     * 根据零售订单id查询发票信息
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoice (int $id) {
        return self::getClass()->invoice([
            "id" => $id,
        ]);
    }

    /**
     * 通过零售订单号获取提货码
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVerifySelfCode () {
        return self::getClass()->getVerifySelfCode([
        ]);
    }

    /**
     * 通过核销取件码，获取零售自提订单核销相关的信息
     *
     * @support  string $code 自提订单提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifySelfOrder () {
        return self::getClass()->verifySelfOrder([
        ]);
    }

    /**
     * 通过核销取件码，设置核销完成，删除该取件码
     *
     * @support  string $code 自提订单提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifySelfOrderRemove () {
        return self::getClass()->verifySelfOrderRemove([
        ]);
    }

    /**
     * 根据订单编号获取订单信息
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPriceInfoByNo (string $orderNo) {
        return self::getClass()->getPriceInfoByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}