<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRemoveOrderTestByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanNotifyByParams(array $params)
 * @method getPictureOnlineRetoucherByParams(array $params)
 * @method getTemplatesByProductIdsByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method cancelAuthByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * (首次登录:)提示用户有未完成的订单审核
     *
     * @param  int $staff_id staff_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRemoveOrderTest (int $staff_id) {
        return self::getClass()->getRemoveOrderTest([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 清除未完成的订单列表提示
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanNotify () {
        return self::getClass()->cleanNotify();
    }

    /**
     * 获取在线看片师信息
     *
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPictureOnlineRetoucher (int $staff_id) {
        return self::getClass()->getPictureOnlineRetoucher([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取产品贴图模板
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTemplatesByProductIds (array $productIds) {
        return self::getClass()->getTemplatesByProductIds([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice([
        ]);
    }

    /**
     * 取消授权
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAuth () {
        return self::getClass()->cancelAuth([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}