<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method searchByParams(array $params)
 * @method isCheckByParams(array $params)
 * @method detailByParams(array $params)
 * @method performanceFindLimitDateByParams(array $params)
 * @method performanceDailyByParams(array $params)
 * @method performanceDetailByParams(array $params)
 * @method exportPerformanceDetailByParams(array $params)
 * @method exportListByParams(array $params)
 */
class Exploit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入每日业绩核对
     *
     * @support  string $report_date 上报日期 [ require true ]
     * @support  float $report_performance 上报业绩金额 require false
     * @support  float $report_market_performance 上报商场业绩金额 [ require true ]
     * @support  int $report_count 门店拍摄订单 [ require true ]
     * @support  int $system_shoot_count 上报拍摄订单 [ require true ]
     * @support  float $alipay 线下支付宝 [ require true ]
     * @support  float $alipay_system 支付宝【系统记录金额】 [ require true ]
     * @support  float $wechat 线下微信 [ require true ]
     * @support  float $wechat_system 微信【系统记录金额】 [ require true ]
     * @support  float $pos 线下刷卡 [ require true ]
     * @support  float $pos_system 线下刷卡【系统记录金额】 [ require true ]
     * @support  float $cash 线下现金 [ require true ]
     * @support  float $cash_system 线下现金【系统记录金额】 [ require true ]
     * @support  float $market_card 商场购物卡 [ require true ]
     * @support  float $market_card_system 商场购物卡【系统记录金额】 [ require true ]
     * @support  string $reason 差异原因 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新业绩
     *
     * @support  string $id 业绩id [ require true ]
     * @support  string $report_date 上报日期 require false
     * @support  float $report_performance 上报业绩金额 require false
     * @support  float $report_market_performance 上报商场业绩金额 require false
     * @support  int $report_count 门店拍摄订单 require false
     * @support  int $system_shoot_count 上报拍摄订单 require false
     * @support  float $alipay 线下支付宝 require false
     * @support  float $alipay_system 支付宝【系统记录金额】 require false
     * @support  float $wechat 线下微信 require false
     * @support  float $wechat_system 微信【系统记录金额】 require false
     * @support  float $pos 线下刷卡 require false
     * @support  float $pos_system 线下刷卡【系统记录金额】 require false
     * @support  float $cash 线下现金 require false
     * @support  float $cash_system 线下现金【系统记录金额】 require false
     * @support  float $market_card 商场购物卡 require false
     * @support  float $market_card_system 商场购物卡【系统记录金额】 require false
     * @support  string $reason 差异原因 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 查询业绩
     *
     * @support  string $report_date_start 上报开始时间 require false
     * @support  string $report_date_end 上报结束时间 require false
     * @support  int $store_id 门店id require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页显示数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 昨日业绩是否已核对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function isCheck () {
        return self::getClass()->isCheck();
    }

    /**
     * 业绩详情
     *
     * @support  string $report_date 时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取绩效查询限制的时间
     *
     * @throws  \Exception
     * @return  array
     */
    public static function performanceFindLimitDate () {
        return self::getClass()->performanceFindLimitDate();
    }

    /**
     * 商场业绩日汇总
     *
     * @support  string $start_date 开始时间 [ require true ]
     * @support  string $end_date 结束时间 [ require true ]
     * @support  int $store_id 门店id require false
     * @throws  \Exception
     * @return  array
     */
    public static function performanceDaily () {
        return self::getClass()->performanceDaily();
    }

    /**
     * 商场业绩明细数据
     *
     * @support  string $start_date 开始时间 [ require true ]
     * @support  string $end_date 结束时间 [ require true ]
     * @support  int $store_id 门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function performanceDetail () {
        return self::getClass()->performanceDetail();
    }

    /**
     * 导出商场业绩明细数据
     *
     * @support  string $start_date 开始时间 [ require true ]
     * @support  string $end_date 结束时间 [ require true ]
     * @support  string $update_at 更新时间 require false
     * @support  int $store_id 门店id require false
     * @throws  \Exception
     * @return  string
     */
    public static function exportPerformanceDetail () {
        return self::getClass()->exportPerformanceDetail();
    }

    /**
     * 导出列表
     *
     * @support  int $staff_id 伙伴id require false
     * @support  int $page_size 每次获取条数 require false
     * @support  int $page 页码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function exportList () {
        return self::getClass()->exportList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Exploit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Exploit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}