<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allMobileListByParams(array|SamplePhotoPoll\AllMobileList\MobileListDto $params)
 * @method getLabelListsByParams(array $params)
 */
class SamplePhotoPoll {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取样片列表
     *
     * @var  SamplePhotoPoll\AllMobileList\MobileListDto $mobileListDto $mobileListDto
     * @throws  \Exception
     * @return  SamplePhotoPoll\AllMobileList\SamplePhotoPollResListDto
     */
    public static function allMobileList (SamplePhotoPoll\AllMobileList\MobileListDto $mobileListDto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->allMobileList($mobileListDto),
            "\Mainto\Bridge\Invokes\HimoProductStore\Photo\SamplePhotoPoll\AllMobileList\SamplePhotoPollResListDto"
        );
    }


    /**
     * 获取样片标签列表
     *
     * @param  int $type 类型｜0 all 7 妆面 8 发型 [ require true ]
     * @throws  \Exception
     * @return  SamplePhotoPoll\GetLabelLists\LabelListResDto[]
     */
    public static function getLabelLists (int $type = 0) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getLabelLists([
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Invokes\HimoProductStore\Photo\SamplePhotoPoll\GetLabelLists\LabelListResDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\SamplePhotoPoll');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\SamplePhotoPoll');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}