<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 * @method canUserMarketCardStoreByParams(array $params)
 * @method listByParams(array $params)
 * @method subcompanyAllByParams(array $params)
 * @method updateByParams(array $params)
 * @method reviewCallbackByParams(array $params)
 * @method storeClassificationListByParams(array $params)
 * @method getGroupsByParams(array $params)
 * @method insuranceDetailByParams(array $params)
 * @method getDepartmentListByParams(array $params)
 * @method getMeituanStoreListByParams(array $params)
 * @method rentalDetailByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据分组获取门店(不传参数则为全部)
     *
     * @support  string $classification 分组维度(填写该参数后sc_id无效) require false
     * @support  uint $sc_id 分组id require false
     * @support  bool $include_delete 是否包含删除 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取门店信息
     *
     * @param  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取可用商场卡门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function canUserMarketCardStore () {
        return self::getClass()->canUserMarketCardStore();
    }

    /**
     * 获取门店列表
     *
     * @support  string $name 店名 require false
     * @support  uint $group_id 集团ID require false
     * @support  string $affiliate_type 加盟类型 require false
     * @support  uint $province_id 省份ID require false
     * @support  uint $city_id 城市ID require false
     * @support  uint $area_id 运营区域ID require false
     * @support  uint $city_type_id 城市类型ID require false
     * @support  string $store_type 品牌 require false
     * @support  string $status 门店状态 require false
     * @support  int $page 页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 查询子公司(不带分页)
     *
     * @support  int $id 公司id require false
     * @support  string $name 公司名称 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function subcompanyAll () {
        return self::getClass()->subcompanyAll();
    }

    /**
     * 修改门店信息
     *
     * @support  string $name 店名 [ require true ]
     * @support  uint $city_id 城市ID [ require true ]
     * @support  int $sc_id 区域分组id [ require true ]
     * @support  uint $province_id 省ID [ require true ]
     * @support  uint $group_id 所属集团ID require false
     * @support  uint $id 门店编号 [ require true ]
     * @support  string $affiliate_type 加盟类型(direct(直营)|join(加盟)) [ require true ]
     * @support  string $start_appointment_time 开始预约时间 format: h:i:s [ require true ]
     * @support  string $stop_appointment_time 结束预约时间 format: h:i:s [ require true ]
     * @support  uint $service_times 门店每时段服务数 require false
     * @support  mixed $extend 附带的信息 [ require true ]
     * @support  uint $sort 门店排序 [ require true ]
     * @support  string $use_pos_status pos机启用状态 require false
     * @support  string $dianping_id 美团门店id require false
     * @support  int $dept_id 部门id [ require true ]
     * @support  string $store_type 门店类型(blue(蓝标)|gold(金标)|kids(儿童)) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewCallback () {
        return self::getClass()->reviewCallback();
    }

    /**
     * 根据区域类型获取门店分类列表
     *
     * @param  string $type 区域划分类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeClassificationList (string $type = 'price_area') {
        return self::getClass()->storeClassificationList([
            "type" => $type,
        ]);
    }

    /**
     * 集团列表
     *
     * @support  uint $page 页码 require false
     * @support  uint $page_size 数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups () {
        return self::getClass()->getGroups();
    }

    /**
     * 查询
     *
     * @support  int $store_id 门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function insuranceDetail () {
        return self::getClass()->insuranceDetail();
    }

    /**
     * 获取部门列表
     *
     * @support  string $type 部门类型(headquarter,himo_store,kid_store,photography_store) [ require true ]
     * @support  bool $no_bind_store 是否获取未绑定的门店 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentList () {
        return self::getClass()->getDepartmentList();
    }

    /**
     * 获取美团对应店铺列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMeituanStoreList () {
        return self::getClass()->getMeituanStoreList();
    }

    /**
     * 查询门店租金
     *
     * @support  int $store_id 门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function rentalDetail () {
        return self::getClass()->rentalDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}